/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.util.ThreadPool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HexHivePanel
extends JPanel {
    private final boolean forceCubes;
    private int hexSideLength;
    private ColoredStroke hexagonBorderPaint;
    private CubePaint emptyHexPaint;
    private CubePaint fullHexPaint;
    private DrawingProperties drawingProperties;
    private final Object drawingPropertiesLock = new Object();
    private BufferedImage bitmap;
    private final Object bitmapLock = new Object();
    private int lastWidth;
    private int lastHeight;
    private ExecutorService threadPool = ThreadPool.newThreadPool("HexHivePool", 1);
    private final int topPadding;
    private final int rightPadding;
    private final int bottomPadding;
    private final int leftPadding;
    private Color backgroundColor;

    HexHivePanel(int hexSideLength, int borderColor, int emptyColor, int fullColor, int backgroundColor, int topPadding, int rightPadding, int bottomPadding, int leftPadding, boolean forceCubes) {
        if (hexSideLength != -1 && hexSideLength < 5) {
            throw new IllegalArgumentException("Invalid hexSideLength (" + hexSideLength + "). Valid hexSideLength are: -1 (dynamic) and >= 5");
        }
        this.setDoubleBuffered(true);
        this.initPaints(borderColor, emptyColor, fullColor, backgroundColor);
        this.hexSideLength = hexSideLength;
        this.topPadding = topPadding;
        this.rightPadding = rightPadding;
        this.bottomPadding = bottomPadding;
        this.leftPadding = leftPadding;
        this.forceCubes = forceCubes;
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateData(HexDataAdapter hexDataAdapter) {
        int canvasWidth = this.getWidth();
        int canvasHeight = this.getHeight();
        if (canvasHeight > 0 && canvasWidth > 0 && hexDataAdapter != null) {
            Object object = this.drawingPropertiesLock;
            synchronized (object) {
                this.drawingProperties = new DrawingProperties(hexDataAdapter, this.hexSideLength, this.hexagonBorderPaint.getLineWidth(), this.leftPadding, this.topPadding, canvasWidth - this.rightPadding, canvasHeight - this.bottomPadding);
            }
            this.lastHeight = this.drawingProperties.height;
            this.lastWidth = this.getWidth();
        }
        if (this.drawingProperties == null) {
            return;
        }
        if (hexDataAdapter != null && hexDataAdapter.getFullHexagonsCount() >= 0 && canvasWidth > 0 && canvasHeight > 0) {
            this.threadPool.execute(() -> {
                BufferedImage backgroundBitmap = this.asyncDraw(hexDataAdapter);
                Object object = this.bitmapLock;
                synchronized (object) {
                    this.bitmap = backgroundBitmap;
                }
            });
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.lastWidth, this.lastHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.drawingProperties != null && this.bitmap != null) {
            g2d.drawImage(this.bitmap, 0, 0, this.bitmap.getWidth(), this.bitmap.getHeight(), null);
        }
    }

    private void initPaints(int numBorderColor, int numEmptyColor, int numFullColor, int bgColor) {
        this.hexagonBorderPaint = new ColoredStroke(0.5f, new Color(numBorderColor, false));
        this.emptyHexPaint = new CubePaint(numEmptyColor, 10);
        this.fullHexPaint = new CubePaint(numFullColor, 30);
        this.backgroundColor = new Color(bgColor);
    }

    private BufferedImage asyncDraw(HexDataAdapter adapter) {
        this.drawingProperties.hexCenterBuffer.setLocation(((DrawingProperties)this.drawingProperties).evenRowOrigin.x, ((DrawingProperties)this.drawingProperties).evenRowOrigin.y);
        boolean evenRow = true;
        int pieceIndex = 0;
        float heightQuarter = this.drawingProperties.hexHeight / 4.0f;
        float threeQuarters = heightQuarter * 3.0f;
        if (this.drawingProperties.numHexs == 1) {
            ((DrawingProperties)this.drawingProperties).hexCenterBuffer.x = ((DrawingProperties)this.drawingProperties).center.x;
            ((DrawingProperties)this.drawingProperties).hexCenterBuffer.y = ((DrawingProperties)this.drawingProperties).center.y;
        }
        boolean drawCubes = this.forceCubes || this.drawingProperties.numHexs <= 500;
        BufferedImage bitmap = new BufferedImage(this.drawingProperties.width, this.drawingProperties.height, 1);
        Graphics2D graphics = bitmap.createGraphics();
        graphics.setPaint(this.backgroundColor);
        graphics.fillRect(0, 0, this.drawingProperties.width, this.drawingProperties.height);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        while (pieceIndex < this.drawingProperties.numHexs) {
            HexHivePanel.drawHexagon(this.drawingProperties, graphics, this.hexagonBorderPaint, adapter.isFull(pieceIndex) ? this.fullHexPaint : this.emptyHexPaint, drawCubes);
            ++pieceIndex;
            ((DrawingProperties)this.drawingProperties).hexCenterBuffer.x = (int)((float)((DrawingProperties)this.drawingProperties).hexCenterBuffer.x + (this.drawingProperties.hexWidth - 2.0f));
            float rightSide = (float)((DrawingProperties)this.drawingProperties).hexCenterBuffer.x + this.drawingProperties.hexWidth / 2.0f;
            if (!(rightSide >= (float)((DrawingProperties)this.drawingProperties).end.x)) continue;
            evenRow = !evenRow;
            ((DrawingProperties)this.drawingProperties).hexCenterBuffer.x = evenRow ? ((DrawingProperties)this.drawingProperties).evenRowOrigin.x : (int)((float)((DrawingProperties)this.drawingProperties).oddRowOrigin.x - this.hexagonBorderPaint.getLineWidth());
            ((DrawingProperties)this.drawingProperties).hexCenterBuffer.y = (int)((float)((DrawingProperties)this.drawingProperties).hexCenterBuffer.y + threeQuarters);
        }
        return bitmap;
    }

    private static float getHexWidth(float sideLength) {
        return (float)(2.0 * (Math.cos(Math.toRadians(30.0)) * (double)sideLength));
    }

    private static float getHexHeight(float sideLength) {
        return 2.0f * sideLength;
    }

    private static float getHexagonSideLength(int drawingAreaWidth, int drawingAreaHeight, int numHexagons) {
        float THREE_HALVES_SQRT_OF_THREE = 2.598076f;
        int fullArea = drawingAreaWidth * drawingAreaHeight;
        float preliminarySideLength = (float)Math.sqrt((float)fullArea / (2.598076f * (float)numHexagons));
        float spaceToUse = 0.9f;
        if (numHexagons < 50) {
            spaceToUse = 0.85f;
        }
        if (numHexagons < 15) {
            spaceToUse = 0.8f;
        }
        return preliminarySideLength * spaceToUse;
    }

    private static void getHexCorner(Point outCorner, Point inCenter, int cornerNumber, float sideLength) {
        double angle_rad = Math.toRadians(60 * cornerNumber + 30);
        outCorner.setLocation((int)((double)inCenter.x + (double)sideLength * Math.cos(angle_rad)), (int)((double)inCenter.y + (double)sideLength * Math.sin(angle_rad)));
    }

    private static void drawHexagon(DrawingProperties drawingProperties, Graphics2D graphics, ColoredStroke borderStroke, CubePaint fillPaint, boolean drawCube) {
        drawingProperties.hexagonBorderPath.reset();
        for (int i = 0; i <= 7; ++i) {
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, i, drawingProperties.hexSideLength);
            if (i == 0) {
                drawingProperties.hexagonBorderPath.moveTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
                continue;
            }
            drawingProperties.hexagonBorderPath.lineTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
        }
        graphics.setPaint(fillPaint.getBaseColor());
        graphics.fill(drawingProperties.hexagonBorderPath);
        drawingProperties.fillPathBuffer.reset();
        if (drawCube) {
            drawingProperties.fillPathBuffer.moveTo(((DrawingProperties)drawingProperties).hexCenterBuffer.x, ((DrawingProperties)drawingProperties).hexCenterBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 1, drawingProperties.hexSideLength);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 2, drawingProperties.hexSideLength);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 3, drawingProperties.hexSideLength);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).hexCenterBuffer.x, ((DrawingProperties)drawingProperties).hexCenterBuffer.y);
            graphics.setPaint(fillPaint.getDarkColor());
            graphics.fill(drawingProperties.fillPathBuffer);
            drawingProperties.fillPathBuffer.reset();
            drawingProperties.fillPathBuffer.moveTo(((DrawingProperties)drawingProperties).hexCenterBuffer.x, ((DrawingProperties)drawingProperties).hexCenterBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 3, drawingProperties.hexSideLength);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 4, drawingProperties.hexSideLength);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 5, drawingProperties.hexSideLength);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            drawingProperties.fillPathBuffer.lineTo(((DrawingProperties)drawingProperties).hexCenterBuffer.x, ((DrawingProperties)drawingProperties).hexCenterBuffer.y);
            graphics.setPaint(fillPaint.getLightColor());
            graphics.fill(drawingProperties.fillPathBuffer);
            graphics.setPaint(borderStroke.getColor());
            graphics.setStroke(borderStroke);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 1, drawingProperties.hexSideLength);
            graphics.drawLine(((DrawingProperties)drawingProperties).hexCenterBuffer.x, ((DrawingProperties)drawingProperties).hexCenterBuffer.y, ((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 3, drawingProperties.hexSideLength);
            graphics.drawLine(((DrawingProperties)drawingProperties).hexCenterBuffer.x, ((DrawingProperties)drawingProperties).hexCenterBuffer.y, ((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            HexHivePanel.getHexCorner(drawingProperties.cornerBuffer, drawingProperties.hexCenterBuffer, 5, drawingProperties.hexSideLength);
            graphics.drawLine(((DrawingProperties)drawingProperties).hexCenterBuffer.x, ((DrawingProperties)drawingProperties).hexCenterBuffer.y, ((DrawingProperties)drawingProperties).cornerBuffer.x, ((DrawingProperties)drawingProperties).cornerBuffer.y);
            graphics.setPaint(fillPaint.getBaseColor());
        }
        graphics.setPaint(borderStroke.getColor());
        graphics.setStroke(borderStroke);
        graphics.draw(drawingProperties.hexagonBorderPath);
        drawingProperties.hexagonBorderPath.reset();
        drawingProperties.cornerBuffer.setLocation(-1, -1);
    }

    public static void main(String[] args) {
        final HexHivePanel hexPanel = new HexHivePanel(50, 2506835, 0xF2F2F2, 3388901, 0xFFFFFF, 0, 0, 0, 0, true);
        final HexDataAdapter mockAdapter = new HexDataAdapter(){

            public void updateData(Object data) {
            }

            @Override
            public int getTotalHexagonsCount() {
                return 10;
            }

            @Override
            public int getFullHexagonsCount() {
                return 0;
            }

            @Override
            public boolean isFull(int hexOffset) {
                return hexOffset % 2 == 0;
            }
        };
        JFrame frame = new JFrame("HexHive Testing Area");
        frame.setDefaultCloseOperation(3);
        frame.setResizable(true);
        frame.setVisible(true);
        frame.add(hexPanel);
        frame.setSize(640, 480);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                hexPanel.updateData(mockAdapter);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                super.componentMoved(e);
                hexPanel.updateData(mockAdapter);
            }
        });
        hexPanel.updateData(mockAdapter);
    }

    private static final class DrawingProperties {
        private final Point evenRowOrigin;
        private final Point oddRowOrigin;
        private final Point hexCenterBuffer = new Point(-1, -1);
        private final Point cornerBuffer = new Point(-1, -1);
        private final GeneralPath fillPathBuffer = new GeneralPath();
        private final GeneralPath hexagonBorderPath = new GeneralPath();
        private Point origin;
        private Point center;
        private Point end;
        private int width;
        private int height;
        private int numHexs;
        private float hexSideLength;
        private float hexHeight;
        private float hexWidth;
        private float hexBorderStrokeWidth;

        DrawingProperties(HexDataAdapter adapter, int hexSideLen, float hexBorderWidth, int left, int top, int right, int bottom) {
            if (adapter == null) {
                throw new RuntimeException("check your logic, you need a data adapter before calling initDrawingProperties");
            }
            this.hexBorderStrokeWidth = hexBorderWidth;
            this.origin = new Point(0, 0);
            this.center = new Point(0, 0);
            this.end = new Point(0, 0);
            this.evenRowOrigin = new Point(0, 0);
            this.oddRowOrigin = new Point(0, 0);
            this.numHexs = adapter.getTotalHexagonsCount();
            this.hexSideLength = hexSideLen;
            this.update(left, top, right, bottom);
        }

        public void update(int left, int top, int right, int bottom) {
            this.origin.x = left;
            this.origin.y = top;
            this.center.x = left + right >> 1;
            this.center.y = top + bottom >> 1;
            this.end.x = right;
            this.end.y = bottom;
            this.width = right - left;
            this.height = bottom - top;
            if (this.hexSideLength == -1.0f) {
                this.hexSideLength = HexHivePanel.getHexagonSideLength(this.width, this.height, this.numHexs);
            }
            this.hexHeight = HexHivePanel.getHexHeight(this.hexSideLength) + 2.0f * this.hexBorderStrokeWidth;
            this.hexWidth = HexHivePanel.getHexWidth(this.hexSideLength) + 2.0f * this.hexBorderStrokeWidth;
            this.evenRowOrigin.x = (int)((float)this.origin.x + this.hexWidth / 2.0f + this.hexBorderStrokeWidth);
            this.evenRowOrigin.y = (int)((float)this.origin.y + this.hexHeight / 2.0f + this.hexBorderStrokeWidth);
            this.oddRowOrigin.x = (int)((float)this.evenRowOrigin.x + this.hexWidth / 2.0f + this.hexBorderStrokeWidth);
            this.oddRowOrigin.y = (int)((float)this.evenRowOrigin.y + this.hexHeight + this.hexBorderStrokeWidth);
            if (this.hexSideLength != -1.0f) {
                Point bufferCenter = new Point(this.evenRowOrigin.x, this.evenRowOrigin.y);
                int consideredHexagons = 1;
                int lastCenterX = this.evenRowOrigin.x;
                int lastRowCenterY = this.evenRowOrigin.y;
                boolean evenRow = true;
                float heightQuarter = this.hexHeight / 4.0f;
                float threeQuarters = heightQuarter * 3.0f;
                while (consideredHexagons <= this.numHexs) {
                    while ((float)bufferCenter.x + this.hexWidth / 2.0f + 2.0f * this.hexBorderStrokeWidth <= (float)right) {
                        lastCenterX = bufferCenter.x;
                        bufferCenter.x = (int)((float)bufferCenter.x + (this.hexWidth + 2.0f * this.hexBorderStrokeWidth));
                        ++consideredHexagons;
                    }
                    lastRowCenterY = bufferCenter.y = (int)((float)bufferCenter.y + (threeQuarters + 2.0f * this.hexBorderStrokeWidth));
                    bufferCenter.x = evenRow ? this.evenRowOrigin.x : this.oddRowOrigin.x;
                    evenRow = !evenRow;
                }
                this.end.x = (int)((float)lastCenterX + this.hexWidth / 2.0f + this.hexBorderStrokeWidth);
                this.end.y = (int)((float)lastRowCenterY + this.hexSideLength + 2.0f * this.hexBorderStrokeWidth);
                this.width = this.end.x - left;
                this.height = this.end.y - top;
            }
        }
    }

    private static final class CubePaint {
        private final Color baseColor;
        private final Color darkColor;
        private final Color lightColor;

        CubePaint(int numBaseColor, int shades) {
            int R = numBaseColor >> 16 & 0xFF;
            int G = numBaseColor >> 8 & 0xFF;
            int B = numBaseColor & 0xFF;
            int darkR = Math.max(R - shades, 0);
            int darkG = Math.max(G - shades, 0);
            int darkB = Math.max(B - shades, 0);
            int lightR = Math.min(R + shades, 255);
            int lightG = Math.min(G + shades, 255);
            int lightB = Math.min(B + shades, 255);
            int numDarkColor = (darkR & 0xFF) << 16 | (darkG & 0xFF) << 8 | darkB & 0xFF;
            int numLightColor = (lightR & 0xFF) << 16 | (lightG & 0xFF) << 8 | lightB & 0xFF;
            this.baseColor = new Color(numBaseColor, false);
            this.darkColor = new Color(numDarkColor, false);
            this.lightColor = new Color(numLightColor, false);
        }

        Color getBaseColor() {
            return this.baseColor;
        }

        Color getDarkColor() {
            return this.darkColor;
        }

        Color getLightColor() {
            return this.lightColor;
        }
    }

    private static final class ColoredStroke
    extends BasicStroke {
        private final Color color;

        ColoredStroke(float width, Color color) {
            super(width, 0, 0);
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static interface HexDataAdapter<T> {
        public void updateData(T var1);

        public int getTotalHexagonsCount();

        public int getFullHexagonsCount();

        public boolean isFull(int var1);
    }
}

