/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadDataLine;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.components.transfers.TransferDetailComponent;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.transfers.TransferState;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public final class TransferDetailGeneral
extends JPanel
implements TransferDetailComponent.TransferDetailPanel {
    private final JProgressBar completionPercentageProgressbar;
    private final JLabel timeElapsedLabel;
    private final JLabel torrentNameLabel;
    private final JLabel completionPercentageLabel;
    private final JLabel timeLeftLabel;
    private final JLabel downloadSpeedLabel;
    private final JLabel downloadedLabel;
    private final JLabel statusLabel;
    private final JLabel downloadSpeedLimitLabel;
    private final JLabel uploadedLabel;
    private final JLabel seedsLabel;
    private final JLabel uploadSpeedLabel;
    private final JLabel totalSizeLabel;
    private final JLabel peersLabel;
    private final JLabel uploadSpeedLimitLabel;
    private final JLabel shareRatioLabel;
    private final JGrayLabel saveLocationGrayLabel;
    private final JLabel saveLocationLabel;
    private final JLabel infoHashLabel;
    private final JButton copyInfoHashButton;
    private final JLabel magnetURLLabel;
    private final JButton copyMagnetURLButton;
    private final JLabel createdOnLabel;
    private final JLabel commentLabel;
    private ActionListener copyInfoHashActionListener;
    private ActionListener copyMagnetURLActionListener;

    TransferDetailGeneral() {
        super(new MigLayout("insets 0 0 0 0, gap 0 0, fillx"));
        JPanel upperPanel = new JPanel(new MigLayout("insets 17px, gap 0 5px, fill"));
        upperPanel.setBackground(new Color(15988215));
        upperPanel.setOpaque(true);
        upperPanel.add((Component)new JLabel("<html><b>" + I18n.tr("Name") + ":</b></html>"), "left, gapleft 2px, gapright 10px");
        this.torrentNameLabel = new JLabel("");
        upperPanel.add((Component)this.torrentNameLabel, "left, gapright 10px");
        upperPanel.add((Component)new JLabel("|"), "left, gapright 10px");
        this.completionPercentageLabel = new JLabel("<html><b>0%</b></html>");
        upperPanel.add((Component)this.completionPercentageLabel, "left, gapright 5px");
        upperPanel.add((Component)new JLabel("<html><b>" + I18n.tr("complete") + "</b></html>"), "left, pushx, wrap");
        this.completionPercentageProgressbar = new JProgressBar();
        upperPanel.add((Component)this.completionPercentageProgressbar, "span 5, growx");
        JPanel midPanel = new JPanel(new MigLayout("insets 18px, gap 5px 5px"));
        midPanel.setBackground(Color.WHITE);
        midPanel.setOpaque(true);
        midPanel.add((Component)new JGrayLabel(I18n.tr("Time elapsed") + ":"), "split 2, gapright 10");
        this.timeElapsedLabel = new JLabel();
        midPanel.add((Component)this.timeElapsedLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Time left") + ":"), "split 2, gapright 10");
        this.timeLeftLabel = new JLabel();
        midPanel.add((Component)this.timeLeftLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Download speed") + ":"), "split 2, gapright 10");
        this.downloadSpeedLabel = new JLabel();
        midPanel.add((Component)this.downloadSpeedLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Status") + ":"), "split 2, gapright 10");
        this.statusLabel = new JLabel();
        midPanel.add((Component)this.statusLabel, "gapright 50, wrap");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Downloaded") + ":"), "split 2, gapright 10");
        this.downloadedLabel = new JLabel();
        midPanel.add((Component)this.downloadedLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Seeds") + ":"), "split 2, gapright 10");
        this.seedsLabel = new JLabel();
        midPanel.add((Component)this.seedsLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Download limit") + ":"), "split 2, gapright 10");
        this.downloadSpeedLimitLabel = new JLabel();
        midPanel.add((Component)this.downloadSpeedLimitLabel, "gapright 50, wrap");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Uploaded") + ":"), "split 2, gapright 10");
        this.uploadedLabel = new JLabel();
        midPanel.add((Component)this.uploadedLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Peers") + ":"), "split 2, gapright 10");
        this.peersLabel = new JLabel();
        midPanel.add((Component)this.peersLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Upload speed") + ":"), "split 2, gapright 10");
        this.uploadSpeedLabel = new JLabel();
        midPanel.add((Component)this.uploadSpeedLabel, "gapright 50, wrap");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Total size") + ":"), "split 2, gapright 10");
        this.totalSizeLabel = new JLabel();
        midPanel.add((Component)this.totalSizeLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Share ratio")), "split 2, gapright 10");
        this.shareRatioLabel = new JLabel();
        midPanel.add((Component)this.shareRatioLabel, "gapright 50");
        midPanel.add((Component)new JGrayLabel(I18n.tr("Upload limit") + ":"), "split 2, gapright 10");
        this.uploadSpeedLimitLabel = new JLabel();
        midPanel.add((Component)this.uploadSpeedLimitLabel, "gapright 50, wrap");
        JPanel lowerPanel = new JPanel(new MigLayout("insets 5px 18px 18px 18px, gap 5px 5px"));
        lowerPanel.setBackground(Color.WHITE);
        lowerPanel.setOpaque(true);
        this.saveLocationGrayLabel = new JGrayLabel("<html><a href=\"#\">" + I18n.tr("Save location") + "</a>:</html>");
        lowerPanel.add((Component)this.saveLocationGrayLabel, "split 2, gapright 10");
        this.saveLocationLabel = new JLabel();
        lowerPanel.add((Component)this.saveLocationLabel, "gapright 60, wrap");
        ImageIcon copy_paste_gray = GUIMediator.getThemeImage("copy_paste_gray.png");
        ImageIcon copy_paste = GUIMediator.getThemeImage("copy_paste.png");
        lowerPanel.add((Component)new JGrayLabel(I18n.tr("InfoHash") + ":"), "split 3, gapright 10");
        this.infoHashLabel = new JLabel();
        lowerPanel.add((Component)this.infoHashLabel, "gapright 10");
        this.copyInfoHashButton = new JButton(copy_paste_gray);
        lowerPanel.add((Component)this.copyInfoHashButton, "wrap");
        lowerPanel.add((Component)new JGrayLabel(I18n.tr("Magnet URL") + ":"), "split 3, gapright 10");
        this.magnetURLLabel = new JLabel();
        lowerPanel.add((Component)this.magnetURLLabel, "gapright 10");
        this.copyMagnetURLButton = new JButton(copy_paste_gray);
        lowerPanel.add((Component)this.copyMagnetURLButton, "wrap");
        lowerPanel.add((Component)new JGrayLabel(I18n.tr("Created On") + ":"), "split 2, gapright 10");
        this.createdOnLabel = new JLabel();
        lowerPanel.add((Component)this.createdOnLabel, "gapright 60, wrap");
        lowerPanel.add((Component)new JGrayLabel(I18n.tr("Comment") + ":"), "split 2, gapright 10");
        this.commentLabel = new JLabel();
        lowerPanel.add((Component)this.commentLabel, "gapright 60, wrap");
        this.copyInfoHashButton.setPressedIcon(copy_paste);
        this.copyInfoHashButton.setContentAreaFilled(false);
        this.copyMagnetURLButton.setContentAreaFilled(false);
        this.copyMagnetURLButton.setPressedIcon(copy_paste);
        JPanel lowerPortionWhiteBGContainer = new JPanel(new MigLayout("insets 0 0 0 0, gap 0 0, fill"));
        lowerPortionWhiteBGContainer.setOpaque(true);
        lowerPortionWhiteBGContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder(new Color(9607073))));
        lowerPortionWhiteBGContainer.add((Component)upperPanel, "top, growx, gapbottom 5px, wrap");
        lowerPortionWhiteBGContainer.add((Component)midPanel, "gap 0 0 0 0, growx, growprioy 0, wrap");
        lowerPortionWhiteBGContainer.add((Component)lowerPanel, "gap 0 0 0 0, grow");
        JScrollPane scrollPane = new JScrollPane(lowerPortionWhiteBGContainer, 20, 31);
        scrollPane.setBackground(new Color(15988215));
        scrollPane.setOpaque(true);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)scrollPane, "grow");
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        if (verticalScrollBar != null) {
            verticalScrollBar.addAdjustmentListener(e -> scrollPane.repaint());
        }
    }

    @Override
    public void updateData(final BittorrentDownload guiBtDownload) {
        if (guiBtDownload == null) {
            return;
        }
        BTDownload btDownload = guiBtDownload.getDl();
        TorrentHandle torrentHandle = btDownload.getTorrentHandle();
        if (!torrentHandle.isValid()) {
            return;
        }
        TorrentStatus status = torrentHandle.status();
        TorrentInfo torrentInfo = torrentHandle.torrentFile();
        this.torrentNameLabel.setText(btDownload.getName());
        int progress = btDownload.getProgress();
        this.completionPercentageLabel.setText("<html><b>" + progress + "%</b></html>");
        this.completionPercentageProgressbar.setMaximum(100);
        this.completionPercentageProgressbar.setValue(progress);
        this.timeElapsedLabel.setText(this.seconds2time(status.activeDuration() / 1000L));
        if (btDownload.getState().equals((Object)TransferState.DOWNLOADING)) {
            this.timeLeftLabel.setText(this.seconds2time(guiBtDownload.getETA()));
        } else {
            this.timeLeftLabel.setText("");
        }
        this.downloadSpeedLabel.setText(GUIUtils.getBytesInHuman(btDownload.getDownloadSpeed()));
        this.downloadedLabel.setText(GUIUtils.getBytesInHuman(btDownload.getTotalBytesReceived()));
        this.statusLabel.setText(BTDownloadDataLine.TRANSFER_STATE_STRING_MAP.get((Object)btDownload.getState()));
        this.downloadSpeedLimitLabel.setText(GUIUtils.getBytesInHuman(btDownload.getDownloadRateLimit()));
        this.uploadedLabel.setText(GUIUtils.getBytesInHuman(btDownload.getTotalBytesSent()));
        this.seedsLabel.setText(String.format("%d %s %s %d %s", btDownload.getConnectedSeeds(), I18n.tr("connected"), I18n.tr("of"), btDownload.getTotalSeeds(), I18n.tr("total")));
        this.uploadSpeedLabel.setText(GUIUtils.getBytesInHuman(btDownload.getUploadSpeed()));
        this.totalSizeLabel.setText(GUIUtils.getBytesInHuman(btDownload.getSize()));
        this.peersLabel.setText(String.format("%d %s %s %d %s", btDownload.getConnectedPeers(), I18n.tr("connected"), I18n.tr("of"), btDownload.getTotalPeers(), I18n.tr("total")));
        this.uploadSpeedLimitLabel.setText(GUIUtils.getBytesInHuman(btDownload.getUploadRateLimit()));
        this.shareRatioLabel.setText(guiBtDownload.getShareRatio());
        this.saveLocationLabel.setText(guiBtDownload.getSaveLocation().getAbsolutePath());
        MouseListener[] mouseListeners = this.saveLocationGrayLabel.getMouseListeners();
        if (mouseListeners != null && mouseListeners.length > 0) {
            for (MouseListener l : mouseListeners) {
                this.saveLocationGrayLabel.removeMouseListener(l);
            }
        }
        this.saveLocationGrayLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GUIMediator.launchExplorer(new File(guiBtDownload.getDl().getSavePath(), guiBtDownload.getName()));
            }
        });
        this.infoHashLabel.setText(btDownload.getInfoHash());
        if (this.copyInfoHashActionListener != null) {
            this.copyInfoHashButton.removeActionListener(this.copyInfoHashActionListener);
        }
        this.copyInfoHashActionListener = e -> GUIMediator.setClipboardContent(btDownload.getInfoHash());
        this.copyInfoHashButton.addActionListener(this.copyInfoHashActionListener);
        String magnetURI = btDownload.magnetUri();
        if (magnetURI.length() > 50) {
            this.magnetURLLabel.setText(magnetURI.substring(0, 49) + "...");
        } else {
            this.magnetURLLabel.setText(magnetURI);
        }
        if (this.copyMagnetURLActionListener != null) {
            this.copyMagnetURLButton.removeActionListener(this.copyMagnetURLActionListener);
        }
        this.copyMagnetURLActionListener = e -> GUIMediator.setClipboardContent(magnetURI);
        this.copyMagnetURLButton.addActionListener(this.copyMagnetURLActionListener);
        this.createdOnLabel.setText(btDownload.getCreated().toString());
        this.commentLabel.setText("<html><body><p style='width: 600px;'>" + torrentInfo.comment() + "</p></body></html>");
    }

    private String seconds2time(long seconds) {
        if (seconds == -1L) {
            return "\u00e2\u0088\u009e";
        }
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;
        StringBuilder time = new StringBuilder();
        if (days != 0L) {
            time.append(Long.toString(days));
            time.append(":");
            if (hours < 10L) {
                time.append("0");
            }
        }
        if (days != 0L || hours != 0L) {
            time.append(Long.toString(hours));
            time.append(":");
            if (minutes < 10L) {
                time.append("0");
            }
        }
        time.append(Long.toString(minutes));
        time.append(":");
        if (seconds < 10L) {
            time.append("0");
        }
        time.append(Long.toString(seconds));
        return time.toString();
    }

    private static class JGrayLabel
    extends JLabel {
        JGrayLabel(String html) {
            super(html);
            this.setForeground(Color.GRAY);
        }
    }
}

