/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.components.transfers.TransferDetailComponent;
import com.frostwire.gui.components.transfers.TransferDetailPeersTableMediator;
import com.frostwire.jlibtorrent.PeerInfo;
import com.frostwire.util.Logger;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public final class TransferDetailPeers
extends JPanel
implements TransferDetailComponent.TransferDetailPanel {
    private static final Logger LOG = Logger.getLogger(TransferDetailPeers.class);
    private final TransferDetailPeersTableMediator tableMediator = new TransferDetailPeersTableMediator();
    private BittorrentDownload btDownload;

    TransferDetailPeers() {
        super(new MigLayout("fillx, insets 0 0 0 0, gap 0 0"));
        this.add((Component)this.tableMediator.getComponent(), "growx, growy");
    }

    @Override
    public void updateData(BittorrentDownload btDownload) {
        if (btDownload != null && btDownload.getDl() != null) {
            if (this.btDownload != btDownload) {
                this.tableMediator.clearTable();
            }
            this.btDownload = btDownload;
            try {
                List<PeerInfo> items = btDownload.getDl().getTorrentHandle().peerInfo();
                if (items != null && items.size() > 0) {
                    if (this.tableMediator.getSize() == 0) {
                        int i = 0;
                        for (PeerInfo item : items) {
                            this.tableMediator.add(new PeerItemHolder(i++, item));
                        }
                    } else {
                        int i = 0;
                        for (PeerInfo item : items) {
                            try {
                                this.tableMediator.update(new PeerItemHolder(i++, item));
                            }
                            catch (IndexOutOfBoundsException ignored) {
                                this.tableMediator.clearTable();
                                this.updateData(btDownload);
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOG.error("Error updating data: " + e.getMessage());
            }
        }
    }

    public class PeerItemHolder {
        final int peerOffset;
        final PeerInfo peerItem;

        PeerItemHolder(int peerOffset, PeerInfo peerItem) {
            this.peerOffset = peerOffset;
            this.peerItem = peerItem;
        }

        public int hashCode() {
            return this.peerOffset;
        }

        public boolean equals(Object obj) {
            return obj instanceof PeerItemHolder && ((PeerItemHolder)obj).peerOffset == this.peerOffset;
        }
    }
}

