/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.filters;

import com.frostwire.gui.filters.AllowFilter;
import com.frostwire.gui.filters.CompositeFilter;
import com.frostwire.gui.filters.KeywordFilter;
import com.frostwire.gui.filters.SearchFilter;
import com.frostwire.gui.filters.SearchFilterFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import java.util.Vector;

public class SearchFilterFactoryImpl
implements SearchFilterFactory {
    @Override
    public SearchFilter createFilter() {
        Vector<KeywordFilter> buf = new Vector<KeywordFilter>();
        String[] badWords = FilterSettings.BANNED_WORDS.getValue();
        boolean filterAdult = FilterSettings.FILTER_ADULT.getValue();
        if (badWords.length != 0 || filterAdult) {
            KeywordFilter kf = new KeywordFilter();
            for (int i = 0; i < badWords.length; ++i) {
                kf.disallow(badWords[i]);
            }
            if (filterAdult) {
                kf.disallowAdult();
            }
            buf.add(kf);
        }
        return SearchFilterFactoryImpl.compose(buf);
    }

    private static SearchFilter compose(Vector<? extends SearchFilter> filters) {
        if (filters.size() == 0) {
            return new AllowFilter();
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        Object[] delegates = new SearchFilter[filters.size()];
        filters.copyInto(delegates);
        return new CompositeFilter((SearchFilter[])delegates);
    }
}

