/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryActionsHolder;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.PlaylistItemBitRateProperty;
import com.frostwire.gui.library.PlaylistItemIntProperty;
import com.frostwire.gui.library.PlaylistItemStarProperty;
import com.frostwire.gui.library.PlaylistItemStringProperty;
import com.frostwire.gui.library.PlaylistItemTrackProperty;
import com.frostwire.gui.player.MediaPlayer;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.NameHolder;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.StringUtils;

public final class LibraryPlaylistsTableDataLine
extends AbstractLibraryTableDataLine<PlaylistItem> {
    static final int SORT_INDEX_IDX = 0;
    private static final LimeTableColumn SORT_INDEX_COLUMN = new LimeTableColumn(0, "PLAYLIST_TABLE_SORT_INDEX", I18n.tr("Index"), 30, true, false, false, PlaylistItemStringProperty.class);
    static final int ACTIONS_IDX = 1;
    private static final LimeTableColumn ACTIONS_COLUMN = new LimeTableColumn(1, "PLAYLIST_TABLE_ACTIONS", I18n.tr("Actions"), 36, true, false, false, LibraryActionsHolder.class);
    static final int STARRED_IDX = 2;
    private static final LimeTableColumn STARRED_COLUMN = new LimeTableColumn(2, "PLAYLIST_TABLE_STARRED", I18n.tr("Starred"), 20, true, false, false, PlaylistItemStarProperty.class);
    private static final int TITLE_IDX = 3;
    private static final LimeTableColumn TITLE_COLUMN = new LimeTableColumn(3, "PLAYLIST_TABLE_TITLE", I18n.tr("Title"), 80, true, NameHolder.class);
    private static final int ARTIST_IDX = 4;
    private static final LimeTableColumn ARTIST_COLUMN = new LimeTableColumn(4, "PLAYLIST_TABLE_ARTIST", I18n.tr("Artist"), 80, true, PlaylistItemStringProperty.class);
    private static final int LENGTH_IDX = 5;
    private static final LimeTableColumn LENGTH_COLUMN = new LimeTableColumn(5, "PLAYLIST_TABLE_LENGTH", I18n.tr("Length"), 150, true, PlaylistItemStringProperty.class);
    private static final int ALBUM_IDX = 6;
    private static final LimeTableColumn ALBUM_COLUMN = new LimeTableColumn(6, "PLAYLIST_TABLE_ALBUM", I18n.tr("Album"), 120, true, PlaylistItemStringProperty.class);
    private static final int TRACK_IDX = 7;
    private static final LimeTableColumn TRACK_COLUMN = new LimeTableColumn(7, "PLAYLIST_TABLE_TRACK", I18n.tr("Track"), 20, true, PlaylistItemTrackProperty.class);
    private static final int GENRE_IDX = 8;
    private static final LimeTableColumn GENRE_COLUMN = new LimeTableColumn(8, "PLAYLIST_TABLE_GENRE", I18n.tr("Genre"), 80, true, PlaylistItemStringProperty.class);
    private static final int BITRATE_IDX = 9;
    private static final LimeTableColumn BITRATE_COLUMN = new LimeTableColumn(9, "PLAYLIST_TABLE_BITRATE", I18n.tr("Bitrate"), 60, true, PlaylistItemBitRateProperty.class);
    private static final int COMMENT_IDX = 10;
    private static final LimeTableColumn COMMENT_COLUMN = new LimeTableColumn(10, "PLAYLIST_TABLE_COMMENT", I18n.tr("Comment"), 20, false, PlaylistItemStringProperty.class);
    static final int SIZE_IDX = 11;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(11, "PLAYLIST_TABLE_SIZE", I18n.tr("Size"), 80, false, PlaylistItemStringProperty.class);
    static final int TYPE_IDX = 12;
    private static final LimeTableColumn TYPE_COLUMN = new LimeTableColumn(12, "PLAYLIST_TABLE_TYPE", I18n.tr("Type"), 40, true, PlaylistItemStringProperty.class);
    private static final int YEAR_IDX = 13;
    private static final LimeTableColumn YEAR_COLUMN = new LimeTableColumn(13, "PLAYLIST_TABLE_YEAR", I18n.tr("Year"), 30, false, PlaylistItemStringProperty.class);
    private static final int NUMBER_OF_COLUMNS = 14;
    private SizeHolder sizeHolder;
    private boolean exists;
    private String bitrate;
    private NameHolder nameCell;
    private LibraryActionsHolder actionsHolder;

    @Override
    public int getColumnCount() {
        return 14;
    }

    @Override
    public void initialize(PlaylistItem item) {
        super.initialize(item);
        this.sizeHolder = new SizeHolder(item.getFileSize());
        this.exists = new File(item.getFilePath()).exists();
        this.bitrate = ((PlaylistItem)this.initializer).getTrackBitrate();
        if (this.bitrate != null && this.bitrate.length() > 0 && !this.bitrate.endsWith(" kbps")) {
            this.bitrate = this.bitrate + " kbps";
        }
        this.nameCell = new NameHolder(((PlaylistItem)this.initializer).getTrackTitle());
        this.actionsHolder = new LibraryActionsHolder(this, false);
    }

    @Override
    public Object getValueAt(int idx) {
        boolean playing = this.isPlaying();
        switch (idx) {
            case 0: {
                return new PlaylistItemIntProperty(this, ((PlaylistItem)this.initializer).getSortIndex(), playing, this.exists);
            }
            case 1: {
                this.actionsHolder.setPlaying(playing);
                return this.actionsHolder;
            }
            case 2: {
                return new PlaylistItemStarProperty(this, playing, this.exists);
            }
            case 6: {
                return new PlaylistItemStringProperty(this, ((PlaylistItem)this.initializer).getTrackAlbum(), playing, this.exists);
            }
            case 4: {
                return new PlaylistItemStringProperty(this, ((PlaylistItem)this.initializer).getTrackArtist(), playing, this.exists);
            }
            case 9: {
                return new PlaylistItemBitRateProperty(this, this.bitrate, playing, this.exists);
            }
            case 10: {
                return new PlaylistItemStringProperty(this, ((PlaylistItem)this.initializer).getTrackComment(), playing, this.exists);
            }
            case 8: {
                return new PlaylistItemStringProperty(this, ((PlaylistItem)this.initializer).getTrackGenre(), playing, this.exists);
            }
            case 5: {
                return new PlaylistItemStringProperty(this, LibraryUtils.getSecondsInDDHHMMSS((int)((PlaylistItem)this.initializer).getTrackDurationInSecs()), playing, this.exists);
            }
            case 11: {
                return new PlaylistItemStringProperty(this, this.sizeHolder.toString(), playing, this.exists);
            }
            case 3: {
                return this.nameCell;
            }
            case 7: {
                return new PlaylistItemTrackProperty(this, ((PlaylistItem)this.initializer).getTrackNumber(), playing, this.exists);
            }
            case 12: {
                return new PlaylistItemStringProperty(this, ((PlaylistItem)this.initializer).getFileExtension(), playing, this.exists);
            }
            case 13: {
                return new PlaylistItemStringProperty(this, ((PlaylistItem)this.initializer).getTrackYear(), playing, this.exists);
            }
        }
        return null;
    }

    private boolean isPlaying() {
        return this.initializer != null && MediaPlayer.instance().isThisBeingPlayed((PlaylistItem)this.initializer);
    }

    @Override
    public LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return SORT_INDEX_COLUMN;
            }
            case 1: {
                return ACTIONS_COLUMN;
            }
            case 2: {
                return STARRED_COLUMN;
            }
            case 6: {
                return ALBUM_COLUMN;
            }
            case 4: {
                return ARTIST_COLUMN;
            }
            case 9: {
                return BITRATE_COLUMN;
            }
            case 10: {
                return COMMENT_COLUMN;
            }
            case 8: {
                return GENRE_COLUMN;
            }
            case 5: {
                return LENGTH_COLUMN;
            }
            case 11: {
                return SIZE_COLUMN;
            }
            case 3: {
                return TITLE_COLUMN;
            }
            case 7: {
                return TRACK_COLUMN;
            }
            case 12: {
                return TYPE_COLUMN;
            }
            case 13: {
                return YEAR_COLUMN;
            }
        }
        return null;
    }

    @Override
    public boolean isClippable(int idx) {
        return false;
    }

    @Override
    public int getTypeAheadColumn() {
        return 2;
    }

    @Override
    public boolean isDynamic(int idx) {
        return false;
    }

    PlaylistItem getPlayListItem() {
        return (PlaylistItem)this.initializer;
    }

    @Override
    public String[] getToolTipArray(int col) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackTitle(), true)) {
            list.add(I18n.tr("Title") + ": " + ((PlaylistItem)this.initializer).getTrackTitle());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackNumber(), true)) {
            list.add(I18n.tr("Track") + ": " + ((PlaylistItem)this.initializer).getTrackNumber());
        }
        list.add(I18n.tr("Duration") + ": " + LibraryUtils.getSecondsInDDHHMMSS((int)((PlaylistItem)this.initializer).getTrackDurationInSecs()));
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackArtist(), true)) {
            list.add(I18n.tr("Artist") + ": " + ((PlaylistItem)this.initializer).getTrackArtist());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackAlbum(), true)) {
            list.add(I18n.tr("Album") + ": " + ((PlaylistItem)this.initializer).getTrackAlbum());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackGenre(), true)) {
            list.add(I18n.tr("Genre") + ": " + ((PlaylistItem)this.initializer).getTrackGenre());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackYear(), true)) {
            list.add(I18n.tr("Year") + ": " + ((PlaylistItem)this.initializer).getTrackYear());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackComment(), true)) {
            list.add(I18n.tr("Comment") + ": " + ((PlaylistItem)this.initializer).getTrackComment());
        }
        if (list.size() == 1) {
            if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getFileName(), true)) {
                list.add(I18n.tr("File") + ": " + ((PlaylistItem)this.initializer).getFileName());
            }
            if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getFilePath(), true)) {
                list.add(I18n.tr("Folder") + ": " + FilenameUtils.getPath(((PlaylistItem)this.initializer).getFilePath()));
            }
            if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackBitrate(), true)) {
                list.add(I18n.tr("Bitrate") + ": " + ((PlaylistItem)this.initializer).getTrackBitrate());
            }
        }
        return list.toArray(new String[0]);
    }

    @Override
    public File getFile() {
        return new File(((PlaylistItem)this.initializer).getFilePath());
    }
}

