/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.LibraryPlaylistsTableDataLine;
import com.frostwire.gui.library.PlaylistItemProperty;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.tables.DefaultTableBevelledCellRenderer;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;

class PlaylistItemStarRenderer
extends DefaultTableBevelledCellRenderer {
    private static final long serialVersionUID = 6800146830099830381L;
    private static final Icon starOn = GUIMediator.getThemeImage("star_on");
    private static final Icon starOff = GUIMediator.getThemeImage("star_off");
    private static final Icon exclamation = GUIMediator.getThemeImage("exclamation");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        final LibraryPlaylistsTableDataLine line = ((PlaylistItemProperty)value).getLine();
        final PlaylistItemProperty cell = (PlaylistItemProperty)value;
        this.setIcon(line.getPlayListItem().isStarred(), cell.exists());
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PlaylistItemStarRenderer.this.setIcon(line.getPlayListItem().isStarred(), cell.exists());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PlaylistItemStarRenderer.this.setIcon(line.getPlayListItem().isStarred(), cell.exists());
            }
        });
        return component;
    }

    private void setIcon(boolean starred, boolean exists) {
        if (!exists) {
            this.setIcon(exclamation);
        } else if (starred) {
            this.setIcon(starOn);
        } else {
            this.setIcon(starOff);
        }
    }
}

