/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.FileSettingDirectoryHolder;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.limewire.setting.FileSetting;
import org.limewire.util.FileUtils;

public class SavedFilesDirectoryHolder
extends FileSettingDirectoryHolder {
    private final MediaType type = MediaType.getAnyTypeMediaType();
    private Set<File> cache = new HashSet<File>();

    public SavedFilesDirectoryHolder(FileSetting saveDir, String name) {
        super(saveDir, name);
    }

    @Override
    public Icon getIcon() {
        return GUIMediator.getThemeImage("save");
    }

    @Override
    public boolean accept(File file) {
        return super.accept(file) && this.type.matches(file.getName()) && !file.isDirectory();
    }

    private Set<File> getFilesRecursively(File folder, Set<File> excludeFolders) {
        if (folder.isDirectory() && excludeFolders.contains(folder)) {
            return Collections.emptySet();
        }
        File[] listFiles = FileUtils.listFiles(folder);
        if (listFiles == null || listFiles.length == 0) {
            return Collections.emptySet();
        }
        HashSet<File> results = new HashSet<File>();
        for (File f : listFiles) {
            if (!f.exists()) continue;
            if (!(f.isDirectory() || this._hideFiles.contains(f) || f.getName().toLowerCase().contains(".ds_store") || this.isPartsFile(f))) {
                results.add(f);
                continue;
            }
            if (!f.isDirectory() || excludeFolders.contains(f)) continue;
            results.addAll(this.getFilesRecursively(f, excludeFolders));
        }
        return results;
    }

    private boolean isPartsFile(File f) {
        return f.getName().startsWith(".") && f.getName().endsWith(".parts");
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public File[] getFiles() {
        if (this.cache != null && this.cache.size() > 0) {
            return this.cache.toArray(new File[0]);
        }
        this._hideFiles = TorrentUtil.getIgnorableFiles();
        Set<File> directoriesToNotInclude = LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue();
        HashSet<File> directoriesToInclude = new HashSet<File>(Collections.singletonList(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue()));
        HashSet<File> files = new HashSet<File>();
        for (File directory : directoriesToInclude) {
            files.addAll(this.getFilesRecursively(directory, directoriesToNotInclude));
        }
        this.cache = new HashSet<File>(files);
        return this.cache.toArray(new File[0]);
    }

    public Collection<File> getCache() {
        return this.cache;
    }
}

