/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.apple.concurrent.Dispatch;
import com.frostwire.gui.mplayer.MPlayerComponent;
import com.frostwire.gui.player.MPlayerUIEventHandler;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaPlayerListener;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.gui.MPlayerMediator;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.SwingUtilities;

public class MPlayerComponentOSX2
extends Canvas
implements MPlayerComponent,
MediaPlayerListener {
    private long view;
    private static final int JMPlayer_addNotify = 1;
    private static final int JMPlayer_dispose = 2;
    private static final int JMPlayer_volumeChanged = 3;
    private static final int JMPlayer_timeInitialized = 4;
    private static final int JMPlayer_progressChanged = 5;
    private static final int JMPlayer_stateChanged = 6;
    private static final int JMPlayer_toggleFS = 7;
    private static final int JMPlayer_statePlaying = 1;
    private static final int JMPlayer_statePaused = 2;
    private static final int JMPlayer_stateClosed = 3;
    private boolean refreshPlayTime = false;

    public MPlayerComponentOSX2() {
        MediaPlayer.instance().addMediaPlayerListener(this);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(25, 25);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 250);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Dispatch.getInstance().getBlockingMainQueueExecutor().execute(new Runnable(){

            @Override
            public void run() {
                MPlayerComponentOSX2.this.view = MPlayerComponentOSX2.this.createNSView(MPlayerComponentOSX2.this.getImagesPath());
                MPlayerComponentOSX2.this.sendMsg(1);
            }
        });
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public boolean toggleFullScreen() {
        this.sendMsg(7);
        return true;
    }

    protected void dispose() {
        this.sendMsg(2);
    }

    public void onVolumeChanged(final float volume) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onVolumeChanged(volume);
            }
        });
    }

    public void onIncrementVolumePressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onVolumeIncremented();
            }
        });
    }

    public void onDecrementVolumePressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onVolumeDecremented();
            }
        });
    }

    public void onSeekToTime(final float seconds) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onSeekToTime(seconds);
            }
        });
    }

    public void onPlayPressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onPlayPressed();
            }
        });
    }

    public void onPausePressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onPausePressed();
            }
        });
    }

    public void onFastForwardPressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onFastForwardPressed();
            }
        });
    }

    public void onRewindPressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onRewindPressed();
            }
        });
    }

    public void onToggleFullscreenPressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onToggleFullscreenPressed();
            }
        });
    }

    public void onProgressSliderStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onProgressSlideStart();
            }
        });
    }

    public void onProgressSliderEnded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerUIEventHandler.instance().onProgressSlideEnd();
            }
        });
    }

    public void onMouseMoved() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerMediator.instance().getMPlayerWindow().showOverlayControls();
            }
        });
    }

    public void onMouseDoubleClick() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerMediator.instance().getMPlayerWindow().toggleFullScreen();
            }
        });
    }

    @Override
    public void mediaOpened(MediaPlayer mediaPlayer, MediaSource mediaSource) {
    }

    @Override
    public void progressChange(MediaPlayer mediaPlayer, float currentTimeInSecs) {
        this.sendMsg(5, Float.valueOf(currentTimeInSecs));
    }

    @Override
    public void volumeChange(MediaPlayer mediaPlayer, double currentVolume) {
        this.sendMsg(3, Float.valueOf((float)currentVolume));
    }

    @Override
    public void stateChange(MediaPlayer mediaPlayer, MediaPlaybackState state) {
        int s;
        switch (state) {
            case Playing: {
                s = 1;
                break;
            }
            case Paused: {
                s = 2;
                break;
            }
            case Closed: {
                s = 3;
                break;
            }
            default: {
                s = -1;
            }
        }
        if (state == MediaPlaybackState.Playing && this.refreshPlayTime) {
            this.refreshPlayTime = false;
            this.sendMsg(4, Float.valueOf(MediaPlayer.instance().getDurationInSecs()));
        }
        if (state != MediaPlaybackState.Playing) {
            this.refreshPlayTime = true;
        }
        if (s != -1) {
            this.sendMsg(6, s);
        }
    }

    @Override
    public void icyInfo(MediaPlayer mediaPlayer, String data) {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void sendMsg(int messageID) {
        this.sendMsg(messageID, null);
    }

    private void sendMsg(final int messageID, final Object message) {
        Dispatch.getInstance().getNonBlockingMainQueueExecutor().execute(new Runnable(){

            @Override
            public void run() {
                MPlayerComponentOSX2.this.awtMessage(MPlayerComponentOSX2.this.view, messageID, message);
            }
        });
    }

    protected String getImagesPath() {
        boolean isRelease = !FrostWireUtils.getFrostWireJarPath().contains("frostwire-desktop");
        return isRelease ? this.getReleaseImagesPath() : "components/resources/src/main/resources/org/limewire/gui/images/";
    }

    private String getReleaseImagesPath() {
        String javaHome = System.getProperty("java.home");
        File f = new File(javaHome).getAbsoluteFile();
        f = f.getParentFile();
        f = f.getParentFile();
        f = f.getParentFile();
        f = f.getParentFile();
        f = new File(f, "Resources");
        return f.getAbsolutePath() + File.separator;
    }

    private native long createNSView(String var1);

    private native void awtMessage(long var1, int var3, Object var4);

    static {
        try {
            System.loadLibrary("JMPlayer");
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }
}

