/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.frostwire.gui.mplayer.AlphaTarget;
import com.frostwire.gui.mplayer.ProgressSlider;
import com.frostwire.gui.mplayer.ProgressSliderListener;
import com.frostwire.gui.player.MPlayerUIEventHandler;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaPlayerListener;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.limewire.util.OSUtils;

public final class MPlayerOverlayControls
extends JDialog
implements ProgressSliderListener,
AlphaTarget,
MediaPlayerListener {
    private JSlider volumeSlider;
    private ProgressSlider progressSlider;
    private JButton playButton;
    private JButton pauseButton;
    private JButton fullscreenExitButton;
    private JButton fullscreenEnterButton;
    private final Timer hideTimer;

    MPlayerOverlayControls(Timer hideTimer) {
        this.hideTimer = hideTimer;
        MediaPlayer player = MediaPlayer.instance();
        player.addMediaPlayerListener(this);
        this.setupUI();
    }

    private void setupUI() {
        Container panel = this.getContentPane();
        ImageIcon backgroundImage = GUIMediator.getThemeImage(OSUtils.isLinux() ? "fc_background_linux" : "fc_background");
        Dimension winSize = new Dimension(backgroundImage.getIconWidth(), backgroundImage.getIconHeight());
        this.setPreferredSize(winSize);
        this.setSize(winSize);
        this.setUndecorated(true);
        try {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        catch (UnsupportedOperationException e) {
            this.setBackground(new Color(0, 0, 0));
        }
        if (OSUtils.isMacOSX()) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            boolean perPixelTransparentSupported = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
            if (perPixelTransparentSupported) {
                this.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        MPlayerOverlayControls.this.setShape(new RoundRectangle2D.Double(0.0, 0.0, MPlayerOverlayControls.this.getWidth(), MPlayerOverlayControls.this.getHeight(), 15.0, 15.0));
                    }
                });
            }
            this.setOpacity(0.9f);
        }
        if (OSUtils.isLinux()) {
            this.setType(Window.Type.POPUP);
        }
        this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        panel.setLayout(null);
        panel.setBounds(0, 0, winSize.width, winSize.height);
        JLabel backgroundJLabel = new JLabel(backgroundImage);
        backgroundJLabel.setOpaque(false);
        backgroundJLabel.setSize(backgroundImage.getIconWidth(), backgroundImage.getIconHeight());
        Point playButtonPos = new Point(236, 13);
        this.playButton = MPlayerOverlayControls.createMPlayerButton("fc_play", playButtonPos);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MPlayerOverlayControls.this.onPlayPressed();
            }
        });
        OverlayControlsMouseAdapter overlayControlsMouseAdapter = new OverlayControlsMouseAdapter();
        this.playButton.addMouseListener(overlayControlsMouseAdapter);
        panel.add(this.playButton);
        Point pauseButtonPos = new Point(236, 13);
        this.pauseButton = MPlayerOverlayControls.createMPlayerButton("fc_pause", pauseButtonPos);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MPlayerOverlayControls.this.onPausePressed();
            }
        });
        this.pauseButton.addMouseListener(overlayControlsMouseAdapter);
        this.pauseButton.addMouseMotionListener(overlayControlsMouseAdapter);
        panel.add(this.pauseButton);
        Point fastForwardButtonPos = new Point(306, 18);
        JButton fastForwardButton = MPlayerOverlayControls.createMPlayerButton("fc_next", fastForwardButtonPos);
        fastForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MPlayerOverlayControls.this.onFastForwardPressed();
            }
        });
        fastForwardButton.addMouseListener(overlayControlsMouseAdapter);
        fastForwardButton.addMouseMotionListener(overlayControlsMouseAdapter);
        panel.add(fastForwardButton);
        Point rewindButtonPos = new Point(182, 18);
        JButton rewindButton = MPlayerOverlayControls.createMPlayerButton("fc_previous", rewindButtonPos);
        rewindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MPlayerOverlayControls.this.onRewindPressed();
            }
        });
        rewindButton.addMouseListener(overlayControlsMouseAdapter);
        rewindButton.addMouseMotionListener(overlayControlsMouseAdapter);
        panel.add(rewindButton);
        Point fullscreenButtonPos = new Point(390, 22);
        this.fullscreenExitButton = MPlayerOverlayControls.createMPlayerButton("fc_fullscreen_exit", fullscreenButtonPos);
        this.fullscreenExitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MPlayerOverlayControls.this.onFullscreenExitPressed();
            }
        });
        this.fullscreenExitButton.addMouseListener(overlayControlsMouseAdapter);
        this.fullscreenExitButton.addMouseMotionListener(overlayControlsMouseAdapter);
        panel.add(this.fullscreenExitButton);
        this.fullscreenEnterButton = MPlayerOverlayControls.createMPlayerButton("fc_fullscreen_enter", fullscreenButtonPos);
        this.fullscreenEnterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MPlayerOverlayControls.this.onFullscreenEnterPressed();
            }
        });
        this.fullscreenEnterButton.addMouseListener(overlayControlsMouseAdapter);
        this.fullscreenEnterButton.addMouseMotionListener(overlayControlsMouseAdapter);
        panel.add(this.fullscreenEnterButton);
        JPanel volumePanel = new JPanel(new BorderLayout());
        volumePanel.setBounds(20, 20, 125, 25);
        volumePanel.setOpaque(false);
        ImageIcon volMinIcon = GUIMediator.getThemeImage("fc_volume_off");
        JLabel volMinLabel = new JLabel(volMinIcon);
        volMinLabel.setOpaque(false);
        volMinLabel.setSize(volMinIcon.getIconWidth(), volMinIcon.getIconHeight());
        volumePanel.add((Component)volMinLabel, "West");
        this.volumeSlider = new JSlider();
        this.volumeSlider.setOpaque(false);
        this.volumeSlider.setFocusable(false);
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MPlayerOverlayControls.this.onVolumeChanged(((JSlider)e.getSource()).getValue());
            }
        });
        this.volumeSlider.addMouseListener(overlayControlsMouseAdapter);
        this.volumeSlider.addMouseMotionListener(overlayControlsMouseAdapter);
        volumePanel.add((Component)this.volumeSlider, "Center");
        ImageIcon volMaxIcon = GUIMediator.getThemeImage("fc_volume_on");
        JLabel volMaxLabel = new JLabel(volMaxIcon);
        volMaxLabel.setSize(volMaxIcon.getIconWidth(), volMaxIcon.getIconHeight());
        volumePanel.add((Component)volMaxLabel, "East");
        panel.add(volumePanel);
        this.progressSlider = new ProgressSlider();
        this.progressSlider.addProgressSliderListener(this);
        this.progressSlider.setLocation(20, 70);
        this.progressSlider.addMouseListener(overlayControlsMouseAdapter);
        this.progressSlider.addMouseMotionListener(overlayControlsMouseAdapter);
        panel.add(this.progressSlider);
        panel.add(backgroundJLabel);
    }

    @Override
    public void setAlpha(final float alpha) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!OSUtils.isLinux()) {
                    MPlayerOverlayControls.this.setOpacity(alpha);
                }
                MPlayerOverlayControls.this.setVisible((double)alpha != 0.0);
            }
        });
    }

    private static JButton createMPlayerButton(String image, Point pos) {
        ImageIcon buttonImage = GUIMediator.getThemeImage(image);
        JButton button = new JButton();
        button.setIcon(buttonImage);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setRolloverEnabled(true);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusPainted(false);
        button.setSize(new Dimension(buttonImage.getIconWidth(), buttonImage.getIconHeight()));
        button.setLocation(pos);
        return button;
    }

    void setIsFullscreen(boolean fullscreen) {
        this.fullscreenExitButton.setVisible(fullscreen);
        this.fullscreenEnterButton.setVisible(!fullscreen);
    }

    private void onPlayPressed() {
        MPlayerUIEventHandler.instance().onPlayPressed();
    }

    private void onPausePressed() {
        MPlayerUIEventHandler.instance().onPausePressed();
    }

    private void onFastForwardPressed() {
        MPlayerUIEventHandler.instance().onFastForwardPressed();
    }

    private void onRewindPressed() {
        MPlayerUIEventHandler.instance().onRewindPressed();
    }

    private void onVolumeChanged(int value) {
        MPlayerUIEventHandler.instance().onVolumeChanged((float)value / 100.0f);
    }

    @Override
    public void onProgressSliderTimeValueChange(float seconds) {
        MPlayerUIEventHandler.instance().onSeekToTime(seconds);
    }

    @Override
    public void onProgressSliderMouseDown() {
        MPlayerUIEventHandler.instance().onProgressSlideStart();
        this.hideTimer.stop();
    }

    @Override
    public void onProgressSliderMouseUp() {
        MPlayerUIEventHandler.instance().onProgressSlideEnd();
        this.hideTimer.restart();
    }

    private void onFullscreenEnterPressed() {
        MPlayerUIEventHandler.instance().onToggleFullscreenPressed();
    }

    private void onFullscreenExitPressed() {
        MPlayerUIEventHandler.instance().onToggleFullscreenPressed();
    }

    @Override
    public void mediaOpened(MediaPlayer mediaPlayer, MediaSource mediaSource) {
    }

    @Override
    public void progressChange(MediaPlayer mediaPlayer, float currentTimeInSecs) {
        double durationInSeconds = mediaPlayer.getDurationInSecs();
        this.progressSlider.setTotalTime((int)Math.round(durationInSeconds));
        this.progressSlider.setCurrentTime((int)Math.round((double)currentTimeInSecs));
    }

    @Override
    public void volumeChange(MediaPlayer mediaPlayer, double currentVolume) {
        this.volumeSlider.setValue((int)(currentVolume * 100.0));
    }

    @Override
    public void stateChange(MediaPlayer mediaPlayer, MediaPlaybackState state) {
        switch (state) {
            case Playing: {
                this.pauseButton.setVisible(true);
                this.playButton.setVisible(false);
                break;
            }
            case Paused: {
                this.pauseButton.setVisible(false);
                this.playButton.setVisible(true);
                break;
            }
            case Closed: {
                this.playButton.setVisible(true);
                this.pauseButton.setVisible(false);
                break;
            }
        }
    }

    @Override
    public void icyInfo(MediaPlayer mediaPlayer, String data) {
    }

    private class OverlayControlsMouseAdapter
    extends MouseAdapter {
        private OverlayControlsMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            MPlayerOverlayControls.this.hideTimer.stop();
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            MPlayerOverlayControls.this.hideTimer.restart();
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
            MPlayerOverlayControls.this.hideTimer.restart();
        }
    }
}

