/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.TextUIWrapper;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class BuddySupport {
    public static final String OUTER_MARGIN = "outerMargin";

    public static void addLeft(Component c, JTextField textField) {
        BuddySupport.add(c, Position.LEFT, textField);
    }

    public static void addRight(Component c, JTextField textField) {
        BuddySupport.add(c, Position.RIGHT, textField);
    }

    public static void add(Component c, Position pos, JTextField textField) {
        TextUIWrapper.getDefaultWrapper().install(textField, true);
        List<Component> leftBuddies = BuddySupport.buddies(Position.LEFT, textField);
        List<Component> rightBuddies = BuddySupport.buddies(Position.RIGHT, textField);
        BuddySupport.setLeft(textField, leftBuddies);
        BuddySupport.setRight(textField, rightBuddies);
        if (leftBuddies.contains(c) || rightBuddies.contains(c)) {
            throw new IllegalStateException("Component already added.");
        }
        if (Position.LEFT == pos) {
            leftBuddies.add(c);
        } else {
            rightBuddies.add(0, c);
        }
        BuddySupport.addToComponentHierarchy(c, pos, textField);
    }

    public static void addGap(int width, Position pos, JTextField textField) {
        BuddySupport.add(BuddySupport.createGap(width), pos, textField);
    }

    public static void setRight(JTextField textField, List<Component> rightBuddies) {
        BuddySupport.set(rightBuddies, Position.RIGHT, textField);
    }

    public static void setLeft(JTextField textField, List<Component> leftBuddies) {
        BuddySupport.set(leftBuddies, Position.LEFT, textField);
    }

    public static void set(List<Component> buddies, Position pos, JTextField textField) {
        textField.putClientProperty((Object)pos, buddies);
    }

    private static void addToComponentHierarchy(Component c, Position pos, JTextField textField) {
        try {
            textField.add(c, pos.toString());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static List<Component> getLeft(JTextField textField) {
        return BuddySupport.getBuddies(Position.LEFT, textField);
    }

    public static List<Component> getRight(JTextField textField) {
        return BuddySupport.getBuddies(Position.RIGHT, textField);
    }

    public static List<Component> getBuddies(Position pos, JTextField textField) {
        return Collections.unmodifiableList(BuddySupport.buddies(pos, textField));
    }

    private static List<Component> buddies(Position pos, JTextField textField) {
        List buddies = (List)textField.getClientProperty((Object)pos);
        if (buddies != null) {
            return buddies;
        }
        return new ArrayList<Component>();
    }

    public static boolean isBuddy(Component c, JTextField textField) {
        return BuddySupport.buddies(Position.LEFT, textField).contains(c) || BuddySupport.buddies(Position.RIGHT, textField).contains(c);
    }

    public static void remove(JComponent c, JTextField textField) {
        BuddySupport.buddies(Position.LEFT, textField).remove(c);
        BuddySupport.buddies(Position.RIGHT, textField).remove(c);
        textField.remove(c);
    }

    public static void removeAll(JTextField textField) {
        List<Component> left = BuddySupport.buddies(Position.LEFT, textField);
        for (Component c : left) {
            textField.remove(c);
        }
        left.clear();
        List<Component> right = BuddySupport.buddies(Position.RIGHT, textField);
        for (Component c : right) {
            textField.remove(c);
        }
        right.clear();
    }

    public static void setOuterMargin(JTextField buddyField, Insets margin) {
        buddyField.putClientProperty(OUTER_MARGIN, margin);
    }

    public static Insets getOuterMargin(JTextField buddyField) {
        return (Insets)buddyField.getClientProperty(OUTER_MARGIN);
    }

    public static void ensureBuddiesAreInComponentHierarchy(JTextField textField) {
        for (Component c : BuddySupport.getLeft(textField)) {
            BuddySupport.addToComponentHierarchy(c, Position.LEFT, textField);
        }
        for (Component c : BuddySupport.getRight(textField)) {
            BuddySupport.addToComponentHierarchy(c, Position.RIGHT, textField);
        }
    }

    public static Component createGap(int width) {
        return Box.createHorizontalStrut(width);
    }

    public static enum Position {
        LEFT,
        RIGHT;

    }
}

