/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.SkinColors;
import com.frostwire.gui.theme.SkinTitledBorder;
import com.frostwire.gui.theme.ThemeMediator;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthPanelUI;

public final class SkinPanelUI
extends SynthPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        ThemeMediator.testComponentCreationThreadingViolation();
        return new SkinPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateOpaque(c);
    }

    private void updateOpaque(JComponent c) {
        if (Boolean.TRUE.equals(c.getClientProperty("skin_property_dark_box_background"))) {
            c.setOpaque(true);
        } else {
            c.setBackground(SkinColors.TRANSPARENT_COLOR);
            c.setOpaque(false);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (Boolean.TRUE.equals(c.getClientProperty("skin_property_dark_box_background"))) {
                g.setColor(SkinColors.DARK_BOX_BACKGROUND_COLOR);
                if (c.getBorder() instanceof SkinTitledBorder) {
                    g.fillRoundRect(0, 0, c.getWidth() - 1, c.getHeight() - 2, 14, 14);
                } else {
                    g.fillRect(0, 0, c.getWidth(), c.getHeight());
                }
            } else {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        } else {
            super.update(g, c);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        super.propertyChange(pce);
        if ("skin_property_dark_box_background".equals(pce.getPropertyName()) && pce.getSource() instanceof JComponent) {
            this.updateOpaque((JComponent)pce.getSource());
        }
    }
}

