/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.frostwire.gui.theme.SkinColors;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SkinScrollBarThumbPainter
extends AbstractSkinPainter {
    private final State state;

    public SkinScrollBarThumbPainter(State state) {
        this.state = state;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (this.testValid(0, 0, width - 2, height - 2)) {
            Shape s1 = this.shapeGenerator.createRectangle(0, 0, width, height);
            g.setColor(SkinColors.SCROLL_THUMB_BORDER_COLOR);
            g.fill(s1);
            Shape s2 = this.shapeGenerator.createRectangle(1, 1, width - 2, height - 1);
            g.setPaint(this.getScrollBarThumbPaint(s2));
            g.fill(s2);
        }
    }

    private Paint getScrollBarThumbPaint(Shape s) {
        switch (this.state) {
            case Enabled: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_THUMB_ENABLED_COLORS);
            }
            case MouseOver: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_THUMB_MOUSEOVER_COLORS);
            }
            case Pressed: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_THUMB_PRESSED_COLORS);
            }
        }
        throw new IllegalArgumentException("Not supported state");
    }

    public static enum State {
        Enabled,
        MouseOver,
        Pressed;

    }
}

