/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.frostwire.gui.theme.ShapeGenerator;
import com.frostwire.gui.theme.SkinColors;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SkinTextFieldBackgroundPainter
extends AbstractSkinPainter {
    private final State state;

    public SkinTextFieldBackgroundPainter(State state) {
        this.state = state;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case Disabled: {
                this.paintDisabledBackground(g, width, height);
                break;
            }
            default: {
                this.paintDefaultBackground(g, width, height);
            }
        }
    }

    private void paintDefaultBackground(Graphics2D g, int width, int height) {
        this.paintBackground(g, width, height, Color.WHITE);
    }

    private void paintDisabledBackground(Graphics2D g, int width, int height) {
        this.paintBackground(g, width, height, SkinColors.GENERAL_DISABLED_BACKGROUND_COLOR);
    }

    private void paintBackground(Graphics2D g, int width, int height, Color color) {
        int x = 1;
        int y = 1;
        int w = width - 2;
        int h = height - 2;
        if (this.testValid(x, y, w, h)) {
            Shape s = this.shapeGenerator.createRoundRectangle(x, y, w, h, ShapeGenerator.CornerSize.BORDER);
            g.setPaint(color);
            g.fill(s);
        }
    }

    public static enum State {
        Disabled,
        Enabled,
        Focused;

    }
}

