/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.DigestUtils;
import com.frostwire.gui.updates.UpdateMediator;
import com.frostwire.gui.updates.UpdateMessage;
import com.frostwire.jlibtorrent.AlertListener;
import com.frostwire.jlibtorrent.ErrorCode;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.SessionHandle;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AlertType;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class InstallerUpdater
implements Runnable {
    private static final Logger LOG = Logger.getLogger(InstallerUpdater.class);
    private TorrentHandle torrentHandle = null;
    private final UpdateMessage updateMessage;
    private File executableFile;
    private static String lastMD5;
    private static boolean isDownloadingUpdate;
    private static int downloadProgress;
    private final boolean forceUpdate;

    InstallerUpdater(UpdateMessage um, boolean force) {
        this.updateMessage = um;
        this.forceUpdate = force;
        isDownloadingUpdate = false;
    }

    static int getUpdateDownloadProgress() {
        return downloadProgress;
    }

    public void start() {
        new Thread((Runnable)this, "InstallerUpdater").start();
    }

    static boolean isDownloadingUpdate() {
        return isDownloadingUpdate;
    }

    @Override
    public void run() {
        if (!this.forceUpdate && !UpdateSettings.AUTOMATIC_INSTALLER_DOWNLOAD.getValue()) {
            return;
        }
        this.cleanupInvalidUpdates();
        if (this.checkIfDownloaded()) {
            this.showUpdateMessage();
        } else {
            isDownloadingUpdate = true;
            if (this.updateMessage.getTorrent() != null) {
                this.handleTorrentDownload();
            } else if (this.updateMessage.getInstallerUrl() != null) {
                this.handleHttpDownload();
            } else {
                isDownloadingUpdate = false;
            }
        }
    }

    private void handleTorrentDownload() {
        File torrentFileLocation = this.downloadDotTorrent();
        try {
            boolean exists;
            boolean bl = exists = torrentFileLocation.exists() || torrentFileLocation.getAbsoluteFile().exists();
            if (exists) {
                this.startTorrentDownload(torrentFileLocation.getAbsolutePath(), UpdateSettings.UPDATES_DIR.getAbsolutePath());
            } else {
                isDownloadingUpdate = false;
            }
        }
        catch (Throwable e) {
            isDownloadingUpdate = false;
            LOG.error("Error starting update torrent download", e);
        }
    }

    private String getFileNameFromHttpUrl() {
        int index = this.updateMessage.getInstallerUrl().lastIndexOf(47);
        return this.updateMessage.getInstallerUrl().substring(index + 1);
    }

    private void handleHttpDownload() {
        File updateFolder = UpdateSettings.UPDATES_DIR;
        String fileName = this.updateMessage.getSaveAs() != null ? this.updateMessage.getSaveAs() : this.getFileNameFromHttpUrl();
        File installerFileLocation = new File(updateFolder, fileName);
        if (!updateFolder.exists()) {
            updateFolder.mkdir();
            updateFolder.setWritable(true);
        }
        try {
            block6: {
                HttpClient httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
                httpClient.setListener(new HttpClient.HttpClientListener(){
                    long contentLength;
                    long downloaded = 0L;

                    @Override
                    public void onError(HttpClient client, Throwable e) {
                        e.printStackTrace();
                    }

                    @Override
                    public void onData(HttpClient client, byte[] buffer, int offset, int length) {
                        this.downloaded += (long)length;
                        downloadProgress = (int)((double)((float)this.downloaded / (float)this.contentLength) * 100.0);
                    }

                    @Override
                    public void onComplete(HttpClient client) {
                    }

                    @Override
                    public void onCancel(HttpClient client) {
                    }

                    @Override
                    public void onHeaders(HttpClient httpClient, Map<String, List<String>> headerFields) {
                        if (headerFields.containsKey("Content-Length")) {
                            this.contentLength = Long.valueOf(headerFields.get("Content-Length").get(0));
                        }
                    }
                });
                try {
                    httpClient.save(this.updateMessage.getInstallerUrl(), installerFileLocation, true);
                }
                catch (HttpClient.HttpRangeException e) {
                    httpClient.save(this.updateMessage.getInstallerUrl(), installerFileLocation, false);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    if (!e2.getMessage().contains("416")) break block6;
                    httpClient.save(this.updateMessage.getInstallerUrl(), installerFileLocation, false);
                }
            }
            isDownloadingUpdate = false;
            this.downloadComplete();
        }
        catch (Throwable e) {
            isDownloadingUpdate = false;
            LOG.error("Failed to download installer: " + this.updateMessage.getInstallerUrl(), e);
        }
    }

    private void startTorrentDownload(String torrentFile, String saveDataPath) {
        TorrentInfo tinfo = new TorrentInfo(new File(torrentFile));
        final Sha1Hash updateInfoHash = tinfo.infoHash();
        AlertListener updateTorrentListener = new AlertListener(){
            TorrentHandle th = null;

            @Override
            public int[] types() {
                return new int[]{AlertType.TORRENT_RESUMED.swig(), AlertType.ADD_TORRENT.swig(), AlertType.PIECE_FINISHED.swig(), AlertType.TORRENT_FINISHED.swig()};
            }

            @Override
            public void alert(Alert<?> alert2) {
                try {
                    int progress;
                    if (InstallerUpdater.this.checkIfDownloaded()) {
                        BTEngine.getInstance().removeListener(this);
                        InstallerUpdater.this.showUpdateMessage();
                    }
                    if (!(alert2 instanceof TorrentAlert)) {
                        return;
                    }
                    Sha1Hash alertSha1Hash = ((TorrentAlert)alert2).handle().infoHash();
                    if (!alertSha1Hash.toHex().equals(updateInfoHash.toHex())) {
                        return;
                    }
                    if (alert2.type().equals((Object)AlertType.ADD_TORRENT) && alertSha1Hash.toHex().equals(updateInfoHash.toHex())) {
                        Sha1Hash sha1 = ((TorrentAlert)alert2).handle().infoHash();
                        this.th = BTEngine.getInstance().find(sha1);
                        InstallerUpdater.this.torrentHandle = this.th;
                        this.th.resume();
                        Thread.sleep(2000L);
                        progress = (int)(InstallerUpdater.this.torrentHandle.status().progress() * 100.0f);
                        if (progress == 100) {
                            isDownloadingUpdate = false;
                            BTEngine.getInstance().removeListener(this);
                            InstallerUpdater.this.downloadComplete();
                            return;
                        }
                    }
                    if (this.th == null) {
                        return;
                    }
                    AlertType type = alert2.type();
                    System.out.println("InstallerUpdater.AlertListener: " + (Object)((Object)type));
                    InstallerUpdater.printTorrentHandleStatus(this.th);
                    switch (type) {
                        case TORRENT_RESUMED: {
                            InstallerUpdater.printTorrentHandleStatus(this.th);
                        }
                        case FILE_ERROR: 
                        case PIECE_FINISHED: {
                            InstallerUpdater.printTorrentHandleStatus(this.th);
                            InstallerUpdater.this.onStateChanged(this.th, this.th.status().state());
                            progress = (int)(InstallerUpdater.this.torrentHandle.status().progress() * 100.0f);
                            if (progress != 100) break;
                            isDownloadingUpdate = false;
                            BTEngine.getInstance().removeListener(this);
                            InstallerUpdater.this.downloadComplete();
                            return;
                        }
                        case TORRENT_FINISHED: {
                            BTEngine.getInstance().removeListener(this);
                            InstallerUpdater.this.onStateChanged(this.th, this.th.status().state());
                            InstallerUpdater.this.downloadComplete();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            BTEngine.getInstance().addListener(updateTorrentListener);
            BTEngine.getInstance().download(tinfo, new File(saveDataPath), (File)null, (Priority[])null, (List<TcpEndpoint>)null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void showUpdateMessage() {
        GUIMediator.safeInvokeLater(() -> {
            if (this.executableFile == null) {
                return;
            }
            String buildsMissedMessage = this.getBuildsMissedMessage();
            DialogOption result = GUIMediator.showYesNoMessage(buildsMissedMessage + this.updateMessage.getMessageInstallerReady(), I18n.tr("Update"), 1);
            if (result == DialogOption.YES) {
                UpdateMediator.openInstallerAndShutdown(this.executableFile);
            }
        });
    }

    private String getBuildsMissedMessage() {
        if (this.updateMessage.getBuild() != null) {
            try {
                int newBuildNumber = Integer.parseInt(this.updateMessage.getBuild());
                int buildDelta = newBuildNumber - FrostWireUtils.getBuildNumber();
                if (buildDelta > 1) {
                    return "<html>" + I18n.tr("Time flies! You have missed the last {0} updates.", buildDelta) + "<br><br>&nbsp;";
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return "";
    }

    private File downloadDotTorrent() {
        File appSpecialShareFolder = UpdateSettings.UPDATES_DIR;
        int index = this.updateMessage.getTorrent().lastIndexOf(47);
        File torrentFileLocation = new File(appSpecialShareFolder, this.updateMessage.getTorrent().substring(index + 1));
        if (!appSpecialShareFolder.exists() && appSpecialShareFolder.mkdir()) {
            appSpecialShareFolder.setWritable(true);
        }
        try {
            InstallerUpdater.downloadTorrentFile(this.updateMessage.getTorrent(), torrentFileLocation);
        }
        catch (Throwable e) {
            LOG.error("Error downloading update torrent file", e);
        }
        return torrentFileLocation;
    }

    private void onStateChanged(TorrentHandle th, TorrentStatus.State state) {
        if (th == null) {
            return;
        }
        this.torrentHandle = th;
        InstallerUpdater.printTorrentHandleStatus(th);
        if (this.torrentDataDownloadedToDisk()) {
            isDownloadingUpdate = false;
            return;
        }
        System.out.println("InstallerUpdater.stateChanged() - " + (Object)((Object)state) + " completed: " + this.torrentHandle.status().isFinished());
        if (state == TorrentStatus.State.SEEDING) {
            isDownloadingUpdate = false;
            System.out.println("InstallerUpdater.stateChanged() - SEEDING!");
            return;
        }
        ErrorCode error = null;
        TorrentStatus status = th.status();
        if (status != null) {
            error = status.errorCode();
        }
        if (error != null && error.value() != 0) {
            isDownloadingUpdate = false;
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            System.out.println(error);
            System.out.println("InstallerUpdater: ERROR - stopIt, startDownload!");
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            try {
                BTEngine.getInstance().remove(th, SessionHandle.DELETE_FILES);
            }
            catch (Throwable e) {
                LOG.error("Error removing download manager on error", e);
            }
        } else if (state == TorrentStatus.State.DOWNLOADING) {
            System.out.println("stateChanged(STATE_DOWNLOADING)");
            downloadProgress = (int)(this.torrentHandle.status().progress() * 100.0f);
        }
    }

    private void downloadComplete() {
        System.out.println("InstallerUpdater.downloadComplete()!!!!");
        InstallerUpdater.printTorrentHandleStatus(this.torrentHandle);
        this.cleanupInvalidUpdates();
        if (this.checkIfDownloaded()) {
            this.showUpdateMessage();
        }
    }

    private void cleanupInvalidUpdates() {
        if (!UpdateSettings.UPDATES_DIR.exists() || !UpdateSettings.UPDATES_DIR.isDirectory()) {
            return;
        }
        File[] files = UpdateSettings.UPDATES_DIR.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        String currentMD5 = this.updateMessage.getRemoteMD5();
        for (File file : files) {
            try {
                String fileMD5 = DigestUtils.getMD5(file);
                if (DigestUtils.compareMD5(currentMD5, fileMD5)) continue;
                System.out.println("InstallerUpdater.cleanupInvalidUpdates() -> removed " + file.getName() + " (file size: " + file.length() + " bytes)");
                if (this.updateMessage.getInstallerUrl() != null && this.updateMessage.getInstallerUrl() != "") {
                    System.out.println("InstallerUpdater.cleanupInvalidUpdates() -> downloaded from " + this.updateMessage.getInstallerUrl());
                }
                System.out.println("InstallerUpdater.cleanupInvalidUpdates() -> expected MD5=" + currentMD5.toLowerCase() + " vs " + file.getName() + " MD5=" + fileMD5 + "\n");
                file.delete();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private boolean checkIfDownloaded() {
        String installerFilename = UpdateMediator.getInstallerFilename(this.updateMessage);
        if (installerFilename == null) {
            return false;
        }
        File f = new File(UpdateSettings.UPDATES_DIR, installerFilename);
        if (!f.exists()) {
            System.out.println("InstallerUpdater.checkIfDownloaded() - File <" + installerFilename + "> does not exist");
            return false;
        }
        this.executableFile = f;
        try {
            lastMD5 = DigestUtils.getMD5(f);
            boolean result = DigestUtils.compareMD5(lastMD5, this.updateMessage.getRemoteMD5());
            if (!result) {
                System.out.println("InstallerUpdater.checkIfDownloaded() - MD5 check failed. expected MD5=" + this.updateMessage.getRemoteMD5().toLowerCase() + " vs " + f.getName() + " MD5=" + lastMD5.toLowerCase() + " (file size: " + f.length() + " bytes)");
            }
            return result;
        }
        catch (Throwable e) {
            LOG.error("Error checking update MD5", e);
            return false;
        }
    }

    private boolean torrentDataDownloadedToDisk() {
        return this.torrentHandle != null && this.torrentHandle.isValid() && (this.torrentHandle.status().isFinished() || this.torrentHandle.status().isSeeding());
    }

    private static void printTorrentHandleStatus(TorrentHandle th) {
        if (th == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Infohash: ");
        buf.append(th.infoHash().toHex());
        buf.append(" Completed:");
        TorrentStatus stats = th.status();
        buf.append(stats.progress());
        buf.append('%');
        buf.append(" Seeds:");
        buf.append(stats.numSeeds());
        buf.append(" Peers:");
        buf.append(stats.numPeers());
        buf.append(" Downloaded:");
        buf.append(stats.totalDone());
        buf.append(" Uploaded:");
        buf.append(stats.totalUpload());
        buf.append(" DSpeed:");
        buf.append(stats.downloadRate());
        buf.append(" USpeed:");
        buf.append(stats.uploadRate());
        while (buf.length() < 80) {
            buf.append(' ');
        }
        buf.append(" TO:");
        buf.append(th.savePath());
        System.out.println(buf.toString());
    }

    static String getLastMD5() {
        return lastMD5;
    }

    private static void downloadTorrentFile(String torrentURL, File saveLocation) throws IOException {
        byte[] contents = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC).getBytes(torrentURL);
        if (saveLocation != null && contents != null && contents.length > 0) {
            if (saveLocation.exists()) {
                saveLocation.delete();
            }
            saveLocation.getParentFile().mkdirs();
            saveLocation.createNewFile();
            saveLocation.setWritable(true);
            FileOutputStream fos = new FileOutputStream(saveLocation, false);
            fos.write(contents);
            fos.flush();
            fos.close();
        }
    }

    static {
        isDownloadingUpdate = false;
        downloadProgress = 0;
    }
}

