/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Address;
import com.frostwire.jlibtorrent.SessionManager;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.ip_interface;
import com.frostwire.jlibtorrent.swig.ip_interface_vector;
import com.frostwire.jlibtorrent.swig.ip_route;
import com.frostwire.jlibtorrent.swig.ip_route_vector;
import com.frostwire.jlibtorrent.swig.libtorrent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EnumNet {
    private EnumNet() {
    }

    public static List<IpInterface> enumInterfaces(SessionManager session2) {
        if (session2.swig() == null) {
            return Collections.emptyList();
        }
        ip_interface_vector v = libtorrent.enum_net_interfaces(session2.swig());
        int size = (int)v.size();
        ArrayList<IpInterface> l = new ArrayList<IpInterface>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new IpInterface(v.get(i)));
        }
        return l;
    }

    public static List<IpRoute> enumRoutes(SessionManager session2) {
        if (session2.swig() == null) {
            return Collections.emptyList();
        }
        ip_route_vector v = libtorrent.enum_routes(session2.swig());
        int size = (int)v.size();
        ArrayList<IpRoute> l = new ArrayList<IpRoute>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new IpRoute(v.get(i)));
        }
        return l;
    }

    public static Address defaultGateway(SessionManager session2, String device, boolean v6) {
        byte[] device_arr;
        if (session2.swig() == null) {
            return new Address();
        }
        if (device == null) {
            device = "";
        }
        try {
            device_arr = device.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new Address(libtorrent.get_default_gateway(session2.swig(), Vectors.bytes2byte_vector(device_arr), v6));
    }

    public static final class IpRoute {
        private final Address destination;
        private final Address netmask;
        private final Address gateway;
        private final String name;
        private final int mtu;

        IpRoute(ip_route route) {
            this.destination = new Address(route.getDestination());
            this.netmask = new Address(route.getNetmask());
            this.gateway = new Address(route.getGateway());
            this.name = Vectors.byte_vector2ascii(route.getName());
            this.mtu = route.getMtu();
        }

        public Address destination() {
            return this.destination;
        }

        public Address netmask() {
            return this.netmask;
        }

        public Address gateway() {
            return this.gateway;
        }

        public String name() {
            return this.name;
        }

        public int mtu() {
            return this.mtu;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("destination: ").append(this.destination);
            sb.append(", netmask: ").append(this.netmask);
            sb.append(", gateway: ").append(this.gateway);
            sb.append(", name: ").append(this.name);
            sb.append(", mtu: ").append(this.mtu);
            return sb.toString();
        }
    }

    public static final class IpInterface {
        private final Address interfaceAddress;
        private final Address netmask;
        private final String name;
        private final String friendlyName;
        private final String description;
        private final boolean preferred;

        IpInterface(ip_interface iface) {
            this.interfaceAddress = new Address(iface.getInterface_address());
            this.netmask = new Address(iface.getNetmask());
            this.name = Vectors.byte_vector2ascii(iface.getName());
            this.friendlyName = Vectors.byte_vector2ascii(iface.getFriendly_name());
            this.description = Vectors.byte_vector2ascii(iface.getDescription());
            this.preferred = iface.getPreferred();
        }

        public Address interfaceAddress() {
            return this.interfaceAddress;
        }

        public Address netmask() {
            return this.netmask;
        }

        public String name() {
            return this.name;
        }

        public String friendlyName() {
            return this.friendlyName;
        }

        public String description() {
            return this.description;
        }

        public boolean preferred() {
            return this.preferred;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("address: ").append(this.interfaceAddress);
            sb.append(", netmask: ").append(this.netmask);
            sb.append(", name: ").append(this.name);
            sb.append(", friendlyName: ").append(this.friendlyName);
            sb.append(", description: ").append(this.description);
            sb.append(", preferred: ").append(this.preferred);
            return sb.toString();
        }
    }
}

