/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AppleDataBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AppleUtf8Box
extends AppleDataBox {
    private byte[] value;

    AppleUtf8Box(int type) {
        super(type);
        this.dataType = 1;
    }

    public String value() {
        return this.value != null ? Utf8.convert(this.value) : null;
    }

    public void value(String value) {
        byte[] byArray = this.value = value != null ? Utf8.convert(value) : null;
        if (this.value != null) {
            this.dataLength = this.value.length + 16;
        }
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        int len = (int)(this.length() - 16L);
        if (len != 0) {
            IO.read(ch, len, buf);
            this.value = new byte[len];
            buf.get(this.value);
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.value != null) {
            buf.put(this.value);
            IO.write(ch, buf.position(), buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 16L;
        if (this.value != null) {
            s += (long)this.value.length;
        }
        this.length(s);
    }
}

