/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.ContainerBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.SampleEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class AudioSampleEntry
extends SampleEntry {
    protected final int[] reserved1 = new int[2];
    protected short channelcount;
    protected short samplesize;
    protected short pre_defined;
    protected short reserved2;
    protected int samplerate;

    AudioSampleEntry(int codingname) {
        super(codingname);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 20, buf);
        IO.get(buf, this.reserved1);
        this.channelcount = buf.getShort();
        this.samplesize = buf.getShort();
        this.pre_defined = buf.getShort();
        this.reserved2 = buf.getShort();
        this.samplerate = buf.getInt();
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        IO.put(buf, this.reserved1);
        buf.putShort(this.channelcount);
        buf.putShort(this.samplesize);
        buf.putShort(this.pre_defined);
        buf.putShort(this.reserved2);
        buf.putInt(this.samplerate);
        IO.write(ch, 20, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 8L;
        s += 20L;
        this.length(s += ContainerBox.length(this.boxes));
    }
}

