/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

final class InputChannel
implements ReadableByteChannel {
    private final ReadableByteChannel ch;
    private long count;

    public InputChannel(ReadableByteChannel ch) {
        this.ch = ch;
        this.count = 0L;
    }

    public long count() {
        return this.count;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.ch.read(dst);
        if (n > 0) {
            this.count += (long)n;
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }
}

