/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AudioSampleEntry;
import com.frostwire.mp4.Bits;
import com.frostwire.mp4.Box;
import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.HandlerBox;
import com.frostwire.mp4.HintSampleEntry;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.IsoMedia;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.SampleEntry;
import com.frostwire.mp4.VisualSampleEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class SampleDescriptionBox
extends FullBox {
    protected int entry_count;
    protected SampleEntry[] entries;

    SampleDescriptionBox() {
        super(stsd);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 4, buf);
        this.entry_count = buf.getInt();
        this.entries = new SampleEntry[this.entry_count];
        int handler_type = this.handler_type();
        for (int i = 0; i < this.entry_count; ++i) {
            SampleEntry e;
            IO.read(ch, 8, buf);
            int size = buf.getInt();
            int type = buf.getInt();
            Long largesize = null;
            if (size == 1) {
                IO.read(ch, 8, buf);
                largesize = buf.getLong();
            }
            if (handler_type == soun) {
                e = new AudioSampleEntry(type);
            } else if (handler_type == vide) {
                e = new VisualSampleEntry(type);
            } else if (handler_type == hint) {
                e = new HintSampleEntry(type);
            } else {
                throw new UnsupportedOperationException("Can't decode for such handler_type: " + Bits.make4cc(handler_type));
            }
            e.size = size;
            e.largesize = largesize;
            long r = ch.count();
            e.read(ch, buf);
            r = ch.count() - r;
            long length = e.length();
            if (r < length) {
                IsoMedia.read(ch, length - r, e, buf, IsoMedia.OnBoxListener.ALL);
            }
            this.entries[i] = e;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.entry_count);
        IO.write(ch, 4, buf);
        for (int i = 0; i < this.entry_count; ++i) {
            SampleEntry b = this.entries[i];
            buf.putInt(b.size);
            buf.putInt(b.type);
            IO.write(ch, 8, buf);
            if (b.largesize != null) {
                buf.putLong(b.largesize);
                IO.write(ch, 8, buf);
            }
            ((Box)b).write(ch, buf);
            IsoMedia.write(ch, b.boxes, buf, IsoMedia.OnBoxListener.ALL);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        for (int i = 0; i < this.entry_count; ++i) {
            SampleEntry e = this.entries[i];
            e.update();
            if (e.size == 1) {
                s += e.largesize.longValue();
                continue;
            }
            s += (long)e.size;
        }
        this.length(s);
    }

    private int handler_type() throws IOException {
        try {
            Box b = this.parent.parent.parent;
            b = b.findFirst(Box.hdlr);
            return ((HandlerBox)b).handler_type;
        }
        catch (Throwable e) {
            throw new IOException("Can't detect handler type for proper reading", e);
        }
    }
}

