/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TrackFragmentBaseMediaDecodeTimeBox
extends FullBox {
    protected long base_media_decode_time;

    TrackFragmentBaseMediaDecodeTimeBox() {
        super(tfdt);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        if (this.version == 1) {
            IO.read(ch, 8, buf);
            this.base_media_decode_time = buf.getLong();
        } else {
            IO.read(ch, 4, buf);
            this.base_media_decode_time = buf.getInt();
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.version == 1) {
            buf.putLong(this.base_media_decode_time);
            IO.write(ch, 8, buf);
        } else {
            buf.putInt((int)this.base_media_decode_time);
            IO.write(ch, 4, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        this.length(s += this.version == 1 ? 8L : 4L);
    }
}

