/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.ContainerBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.SampleEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class VisualSampleEntry
extends SampleEntry {
    protected short pre_defined1;
    protected short reserved1;
    protected final int[] pre_defined2 = new int[3];
    protected short width;
    protected short height;
    protected int horizresolution = 0x480000;
    protected int vertresolution = 0x480000;
    protected int reserved2;
    protected short frame_count = 1;
    protected final byte[] compressorname = new byte[32];
    protected short depth = (short)24;
    protected short pre_defined3 = (short)-1;

    VisualSampleEntry(int codingname) {
        super(codingname);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 70, buf);
        this.pre_defined1 = buf.getShort();
        this.reserved1 = buf.getShort();
        IO.get(buf, this.pre_defined2);
        this.width = buf.getShort();
        this.height = buf.getShort();
        this.horizresolution = buf.getInt();
        this.vertresolution = buf.getInt();
        this.reserved2 = buf.getInt();
        this.frame_count = buf.getShort();
        buf.get(this.compressorname);
        this.depth = buf.getShort();
        this.pre_defined3 = buf.getShort();
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putShort(this.pre_defined1);
        buf.putShort(this.reserved1);
        IO.put(buf, this.pre_defined2);
        buf.putShort(this.width);
        buf.putShort(this.height);
        buf.putInt(this.horizresolution);
        buf.putInt(this.vertresolution);
        buf.putInt(this.reserved2);
        buf.putShort(this.frame_count);
        buf.put(this.compressorname);
        buf.putShort(this.depth);
        buf.putShort(this.pre_defined3);
        IO.write(ch, 70, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 8L;
        s += 2L;
        s += 2L;
        s += 12L;
        s += 2L;
        s += 2L;
        s += 4L;
        s += 4L;
        s += 4L;
        s += 2L;
        s += 32L;
        s += 2L;
        s += 2L;
        this.length(s += ContainerBox.length(this.boxes));
    }
}

