/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.licenses.Licenses;
import com.frostwire.search.FileSearchResult;
import com.frostwire.search.KeywordDetector;
import com.frostwire.search.SearchResult;
import java.util.List;

public final class KeywordFilter {
    private final boolean inclusive;
    private final String keyword;
    private KeywordDetector.Feature feature;

    public KeywordFilter(boolean inclusive, String keyword, KeywordDetector.Feature feature) {
        this.inclusive = inclusive;
        this.keyword = keyword.toLowerCase();
        this.feature = feature;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeywordFilter)) {
            return false;
        }
        KeywordFilter other = (KeywordFilter)obj;
        return this.inclusive == other.inclusive && this.keyword.equals(other.keyword);
    }

    public int hashCode() {
        return this.keyword.hashCode() * (this.inclusive ? 1 : -1);
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public KeywordDetector.Feature getFeature() {
        return this.feature;
    }

    public KeywordFilter negate() {
        return new KeywordFilter(!this.inclusive, this.keyword, this.feature);
    }

    public boolean accept(String lowercaseHaystack) {
        boolean found = lowercaseHaystack.contains(this.keyword);
        return this.inclusive && found || !this.inclusive && !found;
    }

    static String getSearchResultHaystack(SearchResult sr) {
        StringBuilder queryString = new StringBuilder();
        if (sr.getSource() == null) {
            System.err.println("WARNING: " + sr.getClass().getSimpleName() + " has no source!");
        } else {
            queryString.append(sr.getSource());
            queryString.append(" ");
        }
        queryString.append(sr.getDisplayName());
        queryString.append(" ");
        if (sr instanceof FileSearchResult) {
            queryString.append(" ");
            queryString.append(((FileSearchResult)sr).getFilename());
        }
        queryString.append(" ");
        queryString.append(sr.getDetailsUrl());
        if (sr.getLicense() != Licenses.UNKNOWN) {
            queryString.append(sr.getLicense().getName());
        }
        return queryString.toString().toLowerCase();
    }

    public static boolean passesFilterPipeline(SearchResult sr, List<KeywordFilter> filterPipeline) {
        if (filterPipeline == null || filterPipeline.size() == 0) {
            return true;
        }
        String haystack = KeywordFilter.getSearchResultHaystack(sr);
        for (KeywordFilter filter : filterPipeline) {
            if (filter.accept(haystack)) continue;
            return false;
        }
        return true;
    }
}

