/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.frostclick;

import com.frostwire.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgent {
    public static final String OS_KEY = "OS";
    public static final String FW_VERSION_KEY = "FWversion";
    public static final String BUILD_KEY = "FWbuild";
    private final Map<String, String> headerMap;
    public final Pattern osPattern = Pattern.compile("REL_(v.*?)_([0-9\\.]+)_([0-9]+)");
    private final String uuid;

    public UserAgent(String operatingSystem, String fwVersion, String buildNumber) {
        this.headerMap = this.initHeadersMap(this.normalizeUnavailableString(operatingSystem), this.normalizeUnavailableString(fwVersion), this.normalizeUnavailableString(buildNumber));
        this.uuid = UUID.randomUUID().toString();
    }

    public UserAgent(String frostwireUserAgentString, String uuid) {
        String[] split = frostwireUserAgentString.split("-");
        String osVersion = split[4];
        if (split.length == 6) {
            osVersion = osVersion + "-" + split[5];
        }
        osVersion = this.normalizeOsVersionString(osVersion);
        this.headerMap = this.initHeadersMap(osVersion, split[1], split[3]);
        this.uuid = uuid;
    }

    public Map<String, String> getHeadersMap() {
        return this.headerMap;
    }

    public String toString() {
        return "frostwire-" + this.headerMap.get(FW_VERSION_KEY) + "-build-" + this.headerMap.get(BUILD_KEY) + "-" + this.headerMap.get(OS_KEY);
    }

    public String getUUID() {
        return this.uuid;
    }

    public Map<String, String> getOSVersionMap() {
        String v = this.headerMap.get(OS_KEY);
        Map<String, String> osVersion = Collections.emptyMap();
        if (!StringUtils.isNullOrEmpty(v)) {
            String[] split = v.split("_");
            try {
                osVersion = new HashMap<String, String>();
                osVersion.put("CODENAME", split[0]);
                osVersion.put("INCREMENTAL", split[1]);
                osVersion.put("RELEASE", split[2]);
                osVersion.put("SDK_INT", split[3]);
            }
            catch (Throwable t) {
                osVersion = Collections.emptyMap();
            }
        }
        return osVersion;
    }

    private String normalizeOsVersionString(String osVersion) {
        Matcher matcher = this.osPattern.matcher(osVersion);
        if (matcher.find()) {
            osVersion = "REL_" + matcher.group(1).replace('_', '-') + "_" + matcher.group(2) + "_" + matcher.group(3);
        }
        return osVersion;
    }

    private Map<String, String> initHeadersMap(String operatingSystem, String fwVersion, String buildNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(OS_KEY, operatingSystem);
        map.put(FW_VERSION_KEY, fwVersion);
        map.put(BUILD_KEY, buildNumber);
        return map;
    }

    private String normalizeUnavailableString(String str) {
        str = StringUtils.isNullOrEmpty(str) ? "NA" : this.normalizeOsVersionString(str);
        return str;
    }
}

