/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.nyaa;

import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.nyaa.NyaaSearchResult;
import com.frostwire.search.torrent.TorrentSearchPerformer;
import com.frostwire.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NyaaSearchPerformer
extends TorrentSearchPerformer {
    private final int MAX_RESULTS = 75;
    private final Pattern pattern = Pattern.compile("(?is)<tr class=\"default\">.*?<img src=\"(?<thumbnailurl>.*?)\" alt=.*?<a href=\".*?\" class=\"comments\" title=\".*?\">.*?<i class=\"fa fa-comments-o\"></i>.*?<a href=\"(?<detailsurl>.*?)\" title=\"(?<displayname>.*?)\">.*?<td class=\"text-center\" style=\"white-space: nowrap;\">.*?<a href=\"(?<torrenturl>.*?)\"><i class=\"fa fa-fw fa-download\"></i></a>.*?<a href=\"(?<magneturl>.*?)\"><i class=\"fa fa-fw fa-magnet\"></i></a>.*?<td class=\"text-center\">(?<filesize>.*?)</td>.*?<td class=\"text-center\" data-timestamp=\"(?<timestamp>.*?)\">.*?<td class=\"text-center\" style=\"color: green;\">(?<seeds>.*?)</td>");
    private static Logger LOG = Logger.getLogger(NyaaSearchPerformer.class);

    public NyaaSearchPerformer(String domainName, long token, String keywords, int timeout) {
        super(domainName, token, keywords, timeout, 1, 1);
    }

    @Override
    protected String getUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/?f=0&c=0_0&q=" + encodedKeywords;
    }

    protected List<? extends NyaaSearchResult> searchPage(String page) {
        boolean matcherFound;
        if (null == page || page.isEmpty()) {
            return Collections.emptyList();
        }
        int offset = page.indexOf("</thead>");
        if (offset == -1) {
            offset = 0;
        }
        ArrayList<NyaaSearchResult> results = new ArrayList<NyaaSearchResult>(0);
        SearchMatcher matcher = new SearchMatcher(this.pattern.matcher(page));
        do {
            NyaaSearchResult sr;
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error("searchPage() has failed.\n" + t.getMessage(), t);
            }
            if (!matcherFound || (sr = new NyaaSearchResult("https://" + this.getDomainName(), matcher)) == null) continue;
            results.add(sr);
        } while (matcherFound && !this.isStopped() && results.size() <= 75);
        return results;
    }
}

