/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.nyaa;

import com.frostwire.licenses.License;
import com.frostwire.licenses.Licenses;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import java.util.HashMap;
import java.util.Map;

public class NyaaSearchResult
implements TorrentCrawlableSearchResult {
    private final String detailsUrl;
    private final String thumbnailUrl;
    private final String displayName;
    private final String hash;
    private final long creationTime;
    private final String torrentUrl;
    private final String fileName;
    private final int seeds;
    private final long fileSize;
    private static final Map<String, Integer> UNIT_TO_BYTES = new HashMap<String, Integer>();

    NyaaSearchResult(String urlPrefix, SearchMatcher matcher) {
        this.detailsUrl = urlPrefix + matcher.group("detailsurl");
        this.thumbnailUrl = urlPrefix + matcher.group("thumbnailurl");
        this.displayName = matcher.group("displayname");
        this.hash = this.parseHash(matcher.group("magneturl"));
        this.creationTime = Long.valueOf(matcher.group("timestamp"));
        this.fileName = matcher.group("displayname");
        this.torrentUrl = urlPrefix + matcher.group("torrenturl");
        this.seeds = Integer.parseInt(matcher.group("seeds"));
        this.fileSize = this.parseSize(matcher.group("filesize"));
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "Nyaa";
    }

    @Override
    public License getLicense() {
        return Licenses.UNKNOWN;
    }

    @Override
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    @Override
    public String getReferrerUrl() {
        return null;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.fileSize;
    }

    private String parseHash(String magneturl) {
        if (magneturl.startsWith("magnet:?xt=urn:btih:")) {
            return magneturl.substring(20, 52);
        }
        return "";
    }

    private long parseSize(String size) {
        String[] sizearr = size.trim().split(" ");
        String amount = sizearr[0].trim();
        String unit = sizearr[1].trim();
        return this.calculateSize(amount, unit);
    }

    private long calculateSize(String amount, String unit) {
        if (amount == null || unit == null) {
            return -1L;
        }
        Integer unitMultiplier = UNIT_TO_BYTES.get(unit);
        if (unitMultiplier == null) {
            unitMultiplier = UNIT_TO_BYTES.get("bytes");
        }
        if (amount.indexOf(".") > 0) {
            float floatAmount = Float.parseFloat(amount);
            return (long)(floatAmount * (float)unitMultiplier.intValue());
        }
        int intAmount = Integer.parseInt(amount);
        return intAmount * unitMultiplier;
    }

    static {
        UNIT_TO_BYTES.put("bytes", 1);
        UNIT_TO_BYTES.put("B", 1);
        UNIT_TO_BYTES.put("KiB", 1024);
        UNIT_TO_BYTES.put("MiB", 0x100000);
        UNIT_TO_BYTES.put("GiB", 0x40000000);
        UNIT_TO_BYTES.put("TiB", 0);
        UNIT_TO_BYTES.put("PiB", 0);
    }
}

