/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.pixabay;

import com.frostwire.search.AbstractSearchResult;
import com.frostwire.search.CrawlPagedWebSearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.pixabay.PixabayImageSearchResult;
import com.frostwire.search.pixabay.PixabayItem;
import com.frostwire.search.pixabay.PixabayItemSearchResult;
import com.frostwire.search.pixabay.PixabayResponse;
import com.frostwire.search.pixabay.PixabaySearchResult;
import com.frostwire.search.pixabay.PixabayVideoSearchResult;
import com.frostwire.util.JsonUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class PixabaySearchPerformer
extends CrawlPagedWebSearchPerformer<PixabaySearchResult> {
    static final String API_KEY = "qwertzuiop";

    public PixabaySearchPerformer(long token, String keywords, int timeout) {
        super("pixabay.com", token, keywords, timeout, 1, 2);
    }

    @Override
    protected String getUrl(int page, String encodedKeywords) {
        return String.format(Locale.US, "https://pixabay.com/api/?key=%s&q=%s&image_type=photo", API_KEY, encodedKeywords);
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        return this.searchPage(page, true);
    }

    @Override
    protected String getCrawlUrl(PixabaySearchResult sr) {
        return sr.getDetailsUrl();
    }

    @Override
    protected List<? extends SearchResult> crawlResult(PixabaySearchResult sr, byte[] data) throws Exception {
        String json = new String(data, "UTF-8");
        return this.searchPage(json, false);
    }

    private List<? extends SearchResult> searchPage(String page, boolean firstPass) {
        LinkedList<AbstractSearchResult> result = new LinkedList<AbstractSearchResult>();
        PixabayResponse response = JsonUtils.toObject(page, PixabayResponse.class);
        if (firstPass) {
            result.add(new PixabaySearchResult(String.format(Locale.US, "https://pixabay.com/api/videos/?key=%s&q=%s&video_type=film", API_KEY, this.getEncodedKeywords())));
        }
        for (PixabayItem item : response.hits) {
            PixabayItemSearchResult sr;
            if (this.isStopped()) continue;
            if (item.type.equals("photo")) {
                sr = new PixabayImageSearchResult(item);
                result.add(sr);
                continue;
            }
            if (!item.type.equals("film") || item.videos == null || item.videos.tiny == null) continue;
            sr = new PixabayVideoSearchResult(item);
            result.add(sr);
        }
        return result;
    }
}

