/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torlock;

import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import com.frostwire.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public final class TorLockSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    public TorLockSearchResult(String domainName, String detailsUrl, SearchMatcher matcher) {
        this.detailsUrl = detailsUrl;
        this.infoHash = matcher.group("infohash");
        this.filename = this.parseFileName(matcher.group("filename"), FilenameUtils.getBaseName(detailsUrl)).replaceAll("<font color=\".*?\">|</font>", "");
        this.size = this.parseSize(matcher.group("filesize"));
        this.creationTime = this.parseCreationTime(matcher.group("time"));
        this.seeds = this.parseSeeds(matcher.group("seeds"));
        this.torrentUrl = "http://" + domainName + "/tor/" + matcher.group("torrentid") + ".torrent";
        this.displayName = HtmlManipulator.replaceHtmlEntities(FilenameUtils.getBaseName(this.filename));
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "TorLock";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private String parseFileName(String urlEncodedFileName, String fallbackName) {
        String decodedFileName = fallbackName;
        try {
            if (!StringUtils.isNullOrEmpty(urlEncodedFileName)) {
                decodedFileName = URLDecoder.decode(urlEncodedFileName, "UTF-8");
                decodedFileName.replace("&amp;", "and");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedFileName + ".torrent";
    }

    private int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long parseCreationTime(String dateString) {
        long result = System.currentTimeMillis();
        try {
            SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy", Locale.US);
            result = myFormat.parse(dateString).getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

