/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrent;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.CrawlRegexSearchPerformer;
import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.PerformersHelper;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import com.frostwire.util.Logger;
import java.util.LinkedList;
import java.util.List;

public abstract class TorrentRegexSearchPerformer<T extends CrawlableSearchResult>
extends CrawlRegexSearchPerformer<CrawlableSearchResult> {
    private static final Logger LOG = Logger.getLogger(TorrentRegexSearchPerformer.class);
    private final Pattern preliminarySearchResultsPattern;
    private final Pattern htmlDetailPagePattern;

    public TorrentRegexSearchPerformer(String domainName, long token, String keywords, int timeout, int pages, int numCrawls, int regexMaxResults, String preliminarySearchResultsRegex, String htmlDetailPagePatternRegex) {
        super(domainName, token, keywords, timeout, pages, numCrawls, regexMaxResults);
        this.preliminarySearchResultsPattern = Pattern.compile(preliminarySearchResultsRegex);
        this.htmlDetailPagePattern = Pattern.compile(htmlDetailPagePatternRegex);
    }

    @Override
    public Pattern getPattern() {
        return this.preliminarySearchResultsPattern;
    }

    public Pattern getDetailsPattern() {
        return this.htmlDetailPagePattern;
    }

    @Override
    protected String getCrawlUrl(CrawlableSearchResult sr) {
        String crawlUrl = sr instanceof TorrentCrawlableSearchResult ? ((TorrentCrawlableSearchResult)sr).getTorrentUrl() : sr.getDetailsUrl();
        return crawlUrl;
    }

    @Override
    protected List<? extends SearchResult> crawlResult(CrawlableSearchResult sr, byte[] data) throws Exception {
        return this.crawlResult(sr, data, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<? extends SearchResult> crawlResult(CrawlableSearchResult sr, byte[] data, boolean detectAlbums) throws Exception {
        LinkedList<SearchResult> list = new LinkedList<SearchResult>();
        if (data == null) {
            return list;
        }
        if (sr instanceof TorrentCrawlableSearchResult) {
            list.addAll(PerformersHelper.crawlTorrent(this, (TorrentCrawlableSearchResult)sr, data, detectAlbums));
            return list;
        } else {
            String unreducedHtml = new String(data, "UTF-8");
            if (!this.isValidHtml(unreducedHtml)) {
                LOG.warn("invalid html from " + sr.getClass().getSimpleName());
                return list;
            }
            String html = PerformersHelper.reduceHtml(unreducedHtml, this.htmlPrefixOffset(unreducedHtml), this.htmlSuffixOffset(unreducedHtml));
            if (html != null) {
                Matcher matcher = this.htmlDetailPagePattern.matcher(html);
                try {
                    if (matcher.find()) {
                        T searchResult = this.fromHtmlMatcher(sr, SearchMatcher.from(matcher));
                        if (searchResult == null) return list;
                        list.add((SearchResult)searchResult);
                        return list;
                    }
                    LOG.error("TorrentRegexSearchPerformer.crawlSearchResult(" + sr.getClass().getPackage().getName() + "): Update Necessary: Search broken.\n(please notify dev-team on twitter @frostwire or write to contact@frostwire.com if you keep seeing this message.)\npattern: " + this.htmlDetailPagePattern.toString() + "\n" + sr.getDetailsUrl() + "\n\n");
                    return list;
                }
                catch (Throwable e) {
                    throw new Exception("URL:" + sr.getDetailsUrl() + " (" + e.getMessage() + ")", e);
                }
            } else {
                LOG.error("Update Necessary: HTML could not be reduced for optimal search. Search broken for " + sr.getClass().getPackage().getName() + " (please notify dev-team on twitter @frostwire or write to contact@frostwire.com if you keep seeing this message.)");
            }
        }
        return list;
    }

    protected int htmlPrefixOffset(String html) {
        return 0;
    }

    protected int htmlSuffixOffset(String html) {
        return html.length();
    }

    protected abstract T fromHtmlMatcher(CrawlableSearchResult var1, SearchMatcher var2);
}

