/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.yify;

import com.frostwire.search.PerformersHelper;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public final class YifySearchResult
extends AbstractTorrentSearchResult {
    private static final long[] BYTE_MULTIPLIERS = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L};
    private static final Map<String, Integer> UNIT_TO_BYTE_MULTIPLIERS_MAP = new HashMap<String, Integer>();
    private static final Pattern SIZE_PATTERN;
    private final String thumbnailUrl;
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;
    private final String magnetUrl;

    public YifySearchResult(String detailsUrl, SearchMatcher matcher) {
        this.detailsUrl = detailsUrl;
        this.displayName = YifySearchResult.buildDisplayName(matcher);
        this.thumbnailUrl = YifySearchResult.buildThumbnailUrl(matcher.group("cover"));
        this.size = YifySearchResult.buildSize(matcher.group("size"));
        this.creationTime = YifySearchResult.buildCreationTime(matcher.group("creationDate"));
        this.seeds = YifySearchResult.parseSeeds(matcher.group("seeds"));
        this.magnetUrl = matcher.group("magnet").replaceAll("&amp;", "&");
        this.filename = YifySearchResult.buildFileName(detailsUrl);
        this.infoHash = PerformersHelper.parseInfoHash(this.magnetUrl);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getTorrentUrl() {
        return this.magnetUrl;
    }

    @Override
    public String getSource() {
        return "Yify";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    private static String buildDisplayName(SearchMatcher matcher) {
        String displayName = matcher.group("displayName");
        String lang = matcher.group("language");
        if (lang != null) {
            displayName = displayName + " (" + lang + ")";
        }
        return displayName;
    }

    private static String buildThumbnailUrl(String str) {
        if (str == null) {
            return null;
        }
        return str.startsWith("//") ? "https:" + str : "https://www.yify-torrent.org" + str;
    }

    private static long buildCreationTime(String str) {
        try {
            return new SimpleDateFormat("M/d/y").parse(str).getTime();
        }
        catch (Throwable e) {
            return System.currentTimeMillis();
        }
    }

    private static String buildFileName(String detailsUrl) {
        return FilenameUtils.getBaseName(detailsUrl) + ".torrent";
    }

    private static long buildSize(String str) {
        long result = 0L;
        Matcher matcher = SIZE_PATTERN.matcher(str);
        if (matcher.find()) {
            String amount = matcher.group(1);
            String unit = matcher.group(2);
            long multiplier = BYTE_MULTIPLIERS[UNIT_TO_BYTE_MULTIPLIERS_MAP.get(unit)];
            if (amount.indexOf(".") > 0) {
                float floatAmount = Float.parseFloat(amount);
                result = (long)(floatAmount * (float)multiplier);
            } else {
                int intAmount = Integer.parseInt(amount);
                result = (long)intAmount * multiplier;
            }
        }
        return result;
    }

    private static int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    static {
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("B", 0);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("K", 1);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("M", 2);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("G", 3);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("T", 4);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("P", 5);
        SIZE_PATTERN = Pattern.compile("([\\d.]+)([BKMGTP])");
    }
}

