/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public final class JsonUtils {
    private static final Gson gson = new GsonBuilder().create();
    private static final Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();

    private JsonUtils() {
    }

    public static String toJson(Object obj, boolean pretty) {
        return pretty ? gsonPretty.toJson(obj) : gson.toJson(obj);
    }

    public static String toJson(Object obj) {
        return JsonUtils.toJson(obj, false);
    }

    public static <T> T toObject(String json, Class<T> classOfT) {
        return gson.fromJson(json, classOfT);
    }
}

