/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.filetypes;

import com.frostwire.util.filetypes.Action;
import com.frostwire.util.filetypes.AppAssociationReader;
import com.frostwire.util.filetypes.WinRegistryUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WinAppAssociationReader
implements AppAssociationReader {
    @Override
    public String getDescriptionByMimeType(String mimeType) {
        String temFileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (temFileExt != null) {
            return this.getDescriptionByFileExt(temFileExt);
        }
        return null;
    }

    @Override
    public String getDescriptionByFileExt(String fileExt) {
        return WinRegistryUtil.getDescriptionByFileExt(fileExt);
    }

    @Override
    public String getMimeTypeByURL(URL url) {
        return WinRegistryUtil.getMimeTypeByURL(url);
    }

    @Override
    public List<String> getFileExtListByMimeType(String mimeType) {
        String fileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (fileExt != null) {
            ArrayList<String> fileExtList = new ArrayList<String>();
            fileExtList.add(fileExt);
            return fileExtList;
        }
        return null;
    }

    @Override
    public String getMimeTypeByFileExt(String fileExt) {
        return WinRegistryUtil.getMimeTypeByFileExt(fileExt);
    }

    @Override
    public String getIconFileNameByMimeType(String mimeType) {
        String temFileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (temFileExt != null) {
            return this.getIconFileNameByFileExt(temFileExt);
        }
        return null;
    }

    @Override
    public String getIconFileNameByFileExt(String fileExt) {
        return WinRegistryUtil.getIconFileNameByFileExt(fileExt);
    }

    @Override
    public List<Action> getActionListByMimeType(String mimeType) {
        String temFileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (temFileExt != null) {
            return this.getActionListByFileExt(temFileExt);
        }
        return null;
    }

    @Override
    public List<Action> getActionListByFileExt(String fileExt) {
        return WinRegistryUtil.getActionListByFileExt(fileExt);
    }

    @Override
    public boolean isMimeTypeExist(String mimeType) {
        return WinRegistryUtil.isMimeTypeExist(mimeType);
    }

    @Override
    public boolean isFileExtExist(String fileExt) {
        return WinRegistryUtil.isFileExtExist(fileExt);
    }
}

