/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.settings.LibrarySettings;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.util.CommonUtils;

public class LimeCoreGlue {
    private static final AtomicBoolean preinstalled = new AtomicBoolean(false);
    private AtomicBoolean installed = new AtomicBoolean(false);
    private static LimeCoreGlue INSTANCE;

    public static LimeCoreGlue instance() {
        if (INSTANCE == null) {
            INSTANCE = new LimeCoreGlue();
        }
        return INSTANCE;
    }

    private LimeCoreGlue() {
    }

    public static void preinstall() throws InstallFailedException {
        Properties metaConfiguration = CommonUtils.loadMetaConfiguration();
        File portableSettingsDir = null;
        if (!metaConfiguration.isEmpty()) {
            portableSettingsDir = CommonUtils.getPortableSettingsDir(metaConfiguration);
        }
        File userSettingsDir = portableSettingsDir == null ? CommonUtils.getUserSettingsDir() : portableSettingsDir;
        LimeCoreGlue.preinstall(userSettingsDir);
    }

    private static void preinstall(File userSettingsDir) throws InstallFailedException {
        if (!preinstalled.compareAndSet(false, true)) {
            return;
        }
        try {
            CommonUtils.setUserSettingsDir(userSettingsDir);
            LibrarySettings.resetLibraryFoldersIfPortable();
        }
        catch (Exception e) {
            throw new InstallFailedException("Settings Directory Failure", e);
        }
    }

    public void install() {
        if (!this.installed.compareAndSet(false, true)) {
            return;
        }
        LimeCoreGlue.preinstall();
    }

    public static class InstallFailedException
    extends RuntimeException {
        InstallFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

