/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.frostwire.util.UrlUtils;
import com.limegroup.gnutella.util.URIUtils;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class MagnetOptions
implements Serializable {
    private static final String MAGNET = "magnet:?";
    private static final String HTTP = "http://";
    private final Map<Option, List<String>> optionsMap;
    private transient String[] defaultURLs;

    public static MagnetOptions[] parseMagnets(String magnets) {
        ArrayList<MagnetOptions> list = new ArrayList<MagnetOptions>();
        StringTokenizer tokens = new StringTokenizer(magnets, System.getProperty("line.separator"));
        while (tokens.hasMoreTokens()) {
            String next = tokens.nextToken();
            MagnetOptions[] options = MagnetOptions.parseMagnet(next);
            if (options.length <= 0) continue;
            list.addAll(Arrays.asList(options));
        }
        return list.toArray(new MagnetOptions[0]);
    }

    public static MagnetOptions[] parseMagnet(String arg) {
        HashMap<Integer, HashMap<Option, List<String>>> options = new HashMap<Integer, HashMap<Option, List<String>>>();
        if (arg.startsWith("'")) {
            arg = arg.substring(1);
        }
        if (arg.endsWith("'")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        if (!arg.toLowerCase(Locale.US).startsWith(MAGNET)) {
            return new MagnetOptions[0];
        }
        arg = arg.substring(8);
        StringTokenizer st = new StringTokenizer(arg, "&");
        while (st.hasMoreTokens()) {
            Option option;
            int index;
            String cmdstr;
            String keystr;
            block11: {
                keystr = st.nextToken();
                int start = (keystr = keystr.trim()).indexOf("=") + 1;
                if (start == 0) continue;
                cmdstr = keystr.substring(start);
                keystr = keystr.substring(0, start - 1);
                try {
                    cmdstr = URLDecoder.decode(cmdstr);
                }
                catch (IOException e1) {
                    continue;
                }
                int periodLoc = keystr.indexOf(".");
                if (periodLoc > 0) {
                    try {
                        index = Integer.parseInt(keystr.substring(periodLoc + 1));
                        break block11;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                index = 0;
            }
            Integer iIndex = new Integer(index);
            HashMap<Option, List<String>> curOptions = (HashMap<Option, List<String>>)options.get(iIndex);
            if (curOptions == null) {
                curOptions = new HashMap<Option, List<String>>();
                options.put(iIndex, curOptions);
            }
            if ((option = Option.valueFor(keystr)) == null) continue;
            MagnetOptions.addAppend(curOptions, option, cmdstr);
        }
        MagnetOptions[] ret = new MagnetOptions[options.size()];
        int i = 0;
        for (Map current : options.values()) {
            ret[i++] = new MagnetOptions(current);
        }
        return ret;
    }

    private static void addAppend(Map<Option, List<String>> map, Option key, String value) {
        List<String> l = map.get((Object)key);
        if (l == null) {
            l = new ArrayList<String>(1);
            map.put(key, l);
        }
        l.add(value);
    }

    private MagnetOptions(Map<Option, List<String>> options) {
        this.optionsMap = Collections.unmodifiableMap(options);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        StringBuilder ret = new StringBuilder(MAGNET);
        for (String xt : this.getExactTopics()) {
            ret.append("&xt=").append(xt);
        }
        if (this.getDisplayName() != null) {
            ret.append("&dn=").append(UrlUtils.encode(this.getDisplayName()));
        }
        if (this.getKeywordTopic() != null) {
            ret.append("&kt=").append(UrlUtils.encode(this.getKeywordTopic()));
        }
        for (String xs : this.getXS()) {
            ret.append("&xs=").append(xs);
        }
        for (String as : this.getAS()) {
            ret.append("&as=").append(as);
        }
        for (String tr : this.getTR()) {
            ret.append("&tr=").append(tr);
        }
        return ret.toString();
    }

    public boolean isDownloadable() {
        List<String> topics = this.getExactTopics();
        for (String xt : topics) {
            if (!xt.startsWith("urn:btih")) continue;
            return true;
        }
        return this.getDefaultURLs().length > 0;
    }

    public boolean isKeywordTopicOnly() {
        String kt = this.getKeywordTopic();
        String dn = this.getDisplayName();
        return kt != null && kt.length() > 0 && (dn == null || dn.length() > 0) && this.getAS().isEmpty() && this.getXS().isEmpty() && this.getExactTopics().isEmpty();
    }

    private List<String> getPotentialURLs() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.addAll(this.getPotentialURLs(this.getExactTopics()));
        urls.addAll(this.getPotentialURLs(this.getXS()));
        urls.addAll(this.getPotentialURLs(this.getAS()));
        return urls;
    }

    private List<String> getPotentialURLs(List<String> strings) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String str : strings) {
            if (!str.toLowerCase(Locale.US).startsWith(HTTP)) continue;
            ret.add(str);
        }
        return ret;
    }

    public String[] getDefaultURLs() {
        if (this.defaultURLs == null) {
            List<String> urls = this.getPotentialURLs();
            Iterator<String> it = urls.iterator();
            while (it.hasNext()) {
                try {
                    String nextURL = it.next();
                    URIUtils.toURI(nextURL);
                }
                catch (URISyntaxException e) {
                    it.remove();
                }
            }
            this.defaultURLs = urls.toArray(new String[urls.size()]);
        }
        return this.defaultURLs;
    }

    public String getDisplayName() {
        List<String> list = this.optionsMap.get((Object)Option.DN);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getKeywordTopic() {
        List<String> list = this.optionsMap.get((Object)Option.KT);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getExactTopics() {
        return this.getList(Option.XT);
    }

    public List<String> getXS() {
        return this.getList(Option.XS);
    }

    public List<String> getAS() {
        return this.getList(Option.AS);
    }

    public List<String> getTR() {
        return this.getList(Option.TR);
    }

    private List<String> getList(Option key) {
        List<String> l = this.optionsMap.get((Object)key);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    private static enum Option {
        XS,
        XT,
        AS,
        DN,
        KT,
        TR;


        public static Option valueFor(String str) {
            for (Option option : Option.values()) {
                if (!str.toUpperCase(Locale.US).startsWith(option.toString())) continue;
                return option;
            }
            return null;
        }
    }
}

