/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class GUIUtils {
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final Locale LOCALE_ENGLISH = new Locale("en", "");
    private static final Logger LOG = Logger.getLogger(GUIUtils.class);
    private static NumberFormat NUMBER_FORMAT0;
    private static NumberFormat NUMBER_FORMAT1;
    private static DateFormat FULL_DATETIME_FORMAT;
    private static String GENERAL_UNIT_KILOBYTES;
    private static String GENERAL_UNIT_MEGABYTES;
    private static String GENERAL_UNIT_GIGABYTES;
    private static String GENERAL_UNIT_TERABYTES;
    private static String GENERAL_UNIT_KBPSEC;
    private static final HyperlinkListener HYPER_LISTENER;
    private static Action ACTION_DISPOSE;

    private GUIUtils() {
    }

    static void resetLocale() {
        NUMBER_FORMAT0 = NumberFormat.getNumberInstance(GUIMediator.getLocale());
        NUMBER_FORMAT0.setMaximumFractionDigits(0);
        NUMBER_FORMAT0.setMinimumFractionDigits(0);
        NUMBER_FORMAT0.setGroupingUsed(true);
        NUMBER_FORMAT1 = NumberFormat.getNumberInstance(GUIMediator.getLocale());
        NUMBER_FORMAT1.setMaximumFractionDigits(1);
        NUMBER_FORMAT1.setMinimumFractionDigits(1);
        NUMBER_FORMAT1.setGroupingUsed(true);
        FULL_DATETIME_FORMAT = new SimpleDateFormat("EEE, MMM. d, yyyy h:mm a", GUIMediator.getLocale());
        GENERAL_UNIT_KILOBYTES = I18n.tr("KB");
        GENERAL_UNIT_MEGABYTES = I18n.tr("MB");
        GENERAL_UNIT_GIGABYTES = I18n.tr("GB");
        GENERAL_UNIT_TERABYTES = I18n.tr("TB");
        GENERAL_UNIT_KBPSEC = I18n.tr("KB/s");
    }

    public static String getBytesInHuman(long bytes) {
        String unitName;
        long unitValue;
        if (bytes < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        if (bytes < 0xA00000L) {
            unitValue = 1024L;
            unitName = GENERAL_UNIT_KILOBYTES;
        } else if (bytes < 0x280000000L) {
            unitValue = 0x100000L;
            unitName = GENERAL_UNIT_MEGABYTES;
        } else if (bytes < 0xA0000000000L) {
            unitValue = 0x40000000L;
            unitName = GENERAL_UNIT_GIGABYTES;
        } else {
            unitValue = 0x10000000000L;
            unitName = GENERAL_UNIT_TERABYTES;
        }
        NumberFormat numberFormat = (double)bytes * 100.0 / (double)unitValue < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        try {
            return numberFormat.format((double)bytes / (double)unitValue) + " " + unitName;
        }
        catch (ArithmeticException ae) {
            return "0 " + unitName;
        }
    }

    public static String rate2speed(double rate) {
        return NUMBER_FORMAT0.format(rate) + " " + GENERAL_UNIT_KBPSEC;
    }

    public static DateFormat getFullDateTimeFormat() {
        return FULL_DATETIME_FORMAT;
    }

    public static void setOpaque(boolean op, JComponent c) {
        Component[] cs;
        c.setOpaque(op);
        for (Component component : cs = c.getComponents()) {
            if (!(component instanceof JComponent) || component instanceof JTextField || component instanceof JButton) continue;
            ((JComponent)component).setOpaque(op);
            GUIUtils.setOpaque(op, (JComponent)component);
        }
    }

    public static JPanel center(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(1, 0, 0));
        p.add(c);
        return p;
    }

    public static JPanel left(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(c);
        return p;
    }

    public static int width(JLabel c) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return fm.stringWidth(c.getText()) + 3;
    }

    static boolean canDisplay(Font f, String s) {
        int upTo = f.canDisplayUpTo(s);
        return upTo >= s.length() || upTo == -1;
    }

    public static void addHideAction(JDialog jd) {
        GUIUtils.addHideAction((JComponent)jd.getContentPane());
    }

    public static void addHideAction(JComponent jc) {
        InputMap map = jc.getInputMap(1);
        map.put(GUIUtils.getHideKeystroke(), "limewire.hideWindow");
        jc.getActionMap().put("limewire.hideWindow", GUIUtils.getDisposeAction());
    }

    private static KeyStroke getHideKeystroke() {
        if (OSUtils.isMacOSX()) {
            return KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        return KeyStroke.getKeyStroke(27, 0);
    }

    private static void bindKeyToAction(JComponent c, KeyStroke key, Action a, int focusScope) {
        InputMap inputMap = c.getInputMap(focusScope);
        ActionMap actionMap = c.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(key, a);
            actionMap.put(a, a);
        }
    }

    static void bindKeyToAction(JComponent c, KeyStroke key, Action a) {
        GUIUtils.bindKeyToAction(c, key, a, 0);
    }

    public static Action getDisposeAction() {
        if (ACTION_DISPOSE == null) {
            ACTION_DISPOSE = new AbstractAction(){
                private static final long serialVersionUID = 3219036624812939826L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Window parent = ae.getSource() instanceof Window ? (Window)ae.getSource() : SwingUtilities.getWindowAncestor((Component)ae.getSource());
                    if (parent != null) {
                        parent.dispatchEvent(new WindowEvent(parent, 201));
                    }
                }
            };
        }
        return ACTION_DISPOSE;
    }

    public static void fixInputMap(JComponent jc) {
        InputMap map = jc.getInputMap(1);
        if (OSUtils.isMacOSX()) {
            GUIUtils.replaceAction(map, 'A');
            GUIUtils.replaceAction(map, 'C');
            GUIUtils.replaceAction(map, 'V');
            GUIUtils.replaceAction(map, 'X');
        }
    }

    private static void replaceAction(InputMap map, char c) {
        KeyStroke ctrl = KeyStroke.getKeyStroke("control pressed " + c);
        KeyStroke meta = KeyStroke.getKeyStroke("meta pressed " + c);
        if (ctrl == null || meta == null) {
            return;
        }
        Object action = map.get(ctrl);
        if (action != null) {
            map.remove(ctrl);
            map.put(meta, action);
        }
    }

    static HyperlinkListener getHyperlinkListener() {
        return HYPER_LISTENER;
    }

    static MouseListener getURLInputListener(final ActionListener actionListener) {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JComponent comp = (JComponent)e.getComponent();
                comp.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JComponent comp = (JComponent)e.getComponent();
                comp.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                actionListener.actionPerformed(new ActionEvent(e.getComponent(), 0, null));
            }
        };
    }

    static MouseListener getURLInputListener(String url) {
        return GUIUtils.getURLInputListener((ActionEvent e) -> GUIMediator.openURL(url));
    }

    public static boolean shouldShowStartOnStartupWindow() {
        return !CommonUtils.isPortable() && (OSUtils.isMacOSX() || WindowsUtils.isLoginStatusAvailable());
    }

    static String colorToHex(Color colorCode) {
        int r = colorCode.getRed();
        int g = colorCode.getGreen();
        int b = colorCode.getBlue();
        return GUIUtils.toHex(r) + GUIUtils.toHex(g) + GUIUtils.toHex(b);
    }

    private static String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    public static Color hexToColor(String hexString) {
        int decimalColor = Integer.parseInt(hexString, 16);
        return new Color(decimalColor);
    }

    public static boolean launchOrEnqueueFile(File file, boolean audioLaunched) {
        return GUIUtils.launchFile(file, audioLaunched);
    }

    private static boolean launchFile(File file, boolean isPlaying) {
        String extension = FilenameUtils.getExtension(file.getName());
        if (extension != null && extension.toLowerCase().contains("torrent")) {
            GUIMediator.instance().openTorrentFile(file, true);
            return false;
        }
        if (GUIMediator.isPlaylistVisible() && MediaPlayer.isPlayableFile(file)) {
            if (!isPlaying) {
                BackgroundExecutorService.schedule(() -> GUIMediator.safeInvokeAndWait(() -> GUIMediator.instance().launchMedia(new MediaSource(file), false)));
            }
            return true;
        }
        GUIMediator.launchFile(file);
        return false;
    }

    public static void centerOnScreen(JDialog dialog) {
        if (GUIMediator.isAppVisible()) {
            dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            dialog.setLocation(GUIMediator.getScreenCenterPoint(dialog));
        }
    }

    public static void restrictSize(JComponent component, SizePolicy sizePolicy) {
        switch (sizePolicy) {
            case RESTRICT_HEIGHT: {
                int height = component.getPreferredSize().height;
                int width = component.getPreferredSize().width;
                component.setMinimumSize(new Dimension(width, height));
                component.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
                break;
            }
            case RESTRICT_BOTH: {
                int height = component.getPreferredSize().height;
                int width = component.getPreferredSize().width;
                component.setMinimumSize(new Dimension(width, height));
                component.setMaximumSize(new Dimension(width, height));
                break;
            }
            case RESTRICT_NONE: {
                component.setMinimumSize(null);
                component.setMaximumSize(null);
            }
        }
    }

    private static int getCodeForCharKey(String str) {
        int charCode = -1;
        String charStr = str.toUpperCase(Locale.US);
        if (charStr.length() > 1) {
            return -1;
        }
        try {
            Field charField = KeyEvent.class.getField("VK_" + charStr);
            charCode = charField.getInt(KeyEvent.class);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            LOG.error("can't get key for: " + charStr, e);
        }
        return charCode;
    }

    private static int getAmpersandPosition(String text) {
        int index = -1;
        while (!((index = text.indexOf(38, index + 1)) == -1 || index < text.length() - 1 && Character.isLetterOrDigit(text.charAt(index + 1)))) {
        }
        return index;
    }

    public static String stripAmpersand(String text) {
        int index = GUIUtils.getAmpersandPosition(text);
        if (index >= 0) {
            return text.substring(0, index) + text.substring(index + 1);
        }
        return text;
    }

    public static int getMnemonicKeyCode(String text) {
        int index = GUIUtils.getAmpersandPosition(text);
        if (index >= 0) {
            return GUIUtils.getCodeForCharKey(text.substring(index + 1, index + 2));
        }
        return -1;
    }

    public static void adjustColumnWidth(TableModel model, int columnIndex, int maxWidth, int rightPadding, JTable table) {
        if (columnIndex > model.getColumnCount() - 1) {
            return;
        }
        if (!model.getColumnClass(columnIndex).equals(String.class)) {
            return;
        }
        String longestValue = "";
        for (int row = 0; row < model.getRowCount(); ++row) {
            String strValue = (String)model.getValueAt(row, columnIndex);
            if (strValue == null || strValue.length() <= longestValue.length()) continue;
            longestValue = strValue;
        }
        Graphics g = table.getGraphics();
        try {
            int suggestedWidth = (int)g.getFontMetrics(table.getFont()).getStringBounds(longestValue, g).getWidth();
            table.getColumnModel().getColumn(columnIndex).setPreferredWidth((suggestedWidth > maxWidth ? maxWidth : suggestedWidth) + rightPadding);
        }
        catch (Exception e) {
            table.getColumnModel().getColumn(columnIndex).setPreferredWidth(maxWidth);
            e.printStackTrace();
        }
    }

    public static void setTitledBorderOnPanel(JPanel panel, String title) {
        TitledBorder titleBorder = BorderFactory.createTitledBorder(title);
        Border lineBorder = BorderFactory.createLineBorder(ThemeMediator.LIGHT_BORDER_COLOR);
        CompoundBorder border = BorderFactory.createCompoundBorder(lineBorder, titleBorder);
        panel.setBorder(border);
        panel.putClientProperty("skin_property_dark_box_background", Boolean.TRUE);
    }

    private static /* synthetic */ void lambda$launchFile$3(File file) {
        GUIMediator.safeInvokeAndWait(() -> GUIMediator.instance().launchMedia(new MediaSource(file), false));
    }

    static {
        HYPER_LISTENER = he -> {
            URL url;
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = he.getURL()) != null) {
                GUIMediator.openURL(url.toExternalForm());
            }
        };
        GUIUtils.resetLocale();
    }

    public static enum SizePolicy {
        RESTRICT_NONE,
        RESTRICT_HEIGHT,
        RESTRICT_BOTH;

    }

    public static class EmptyIcon
    implements Icon {
        private final String name;
        private final int width;
        private final int height;

        public EmptyIcon(String name, int width, int height) {
            this.name = name;
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        public String toString() {
            return this.name;
        }
    }
}

