/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.jlibtorrent.swig.libtorrent_jni;
import com.limegroup.gnutella.gui.AWTSplashWindow;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.limewire.util.OSUtils;

public class Main {
    private static URL CHOSEN_SPLASH_URL = null;

    public static void main(String[] args) {
        String jlibtorrentPath;
        ThemeMediator.changeTheme();
        System.setProperty("sun.awt.noerasebackground", "true");
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        if (OSUtils.isWindows() && !OSUtils.isMachineX64()) {
            jlibtorrentPath = Main.getWindows32JLibtorrentPath();
            System.setProperty("jlibtorrent.jni.path", jlibtorrentPath);
        }
        if (OSUtils.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        }
        if (OSUtils.isLinux() && !OSUtils.isMachineX64()) {
            jlibtorrentPath = Main.getLinux32JLibtorrentPath();
            System.setProperty("jlibtorrent.jni.path", jlibtorrentPath);
        }
        libtorrent_jni.version();
        Frame splash = null;
        try {
            if (args == null || args.length == 0) {
                splash = Main.showInitialSplash();
            }
            try {
                Class.forName("com.limegroup.gnutella.gui.GUILoader").getMethod("load", String[].class, Frame.class).invoke(null, args, splash);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Frame showInitialSplash() {
        Frame splashFrame = null;
        BufferedImage image = null;
        URL imageURL = Main.getChosenSplashURL();
        if (imageURL != null) {
            try {
                image = ImageIO.read(imageURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null) {
                splashFrame = AWTSplashWindow.splash(image);
            }
        }
        return splashFrame;
    }

    public static URL getChosenSplashURL() {
        if (CHOSEN_SPLASH_URL != null) {
            return CHOSEN_SPLASH_URL;
        }
        String splashPath = "org/limewire/gui/images/app_splash.jpg";
        CHOSEN_SPLASH_URL = ClassLoader.getSystemResource("org/limewire/gui/images/app_splash.jpg");
        return CHOSEN_SPLASH_URL;
    }

    private static String getWindows32JLibtorrentPath() {
        String jarPath = new File(FrostWireUtils.getFrostWireJarPath()).getAbsolutePath();
        boolean isRelease = !(jarPath = jarPath.replaceAll("%20", " ")).contains("frostwire-desktop");
        String libPath = jarPath + File.separator + (isRelease ? "jlibtorrentX86.dll" : "lib/native/jlibtorrentX86.dll");
        if (!new File(libPath).exists()) {
            libPath = new File(jarPath + File.separator + "../../lib/native/jlibtorrentx86.dll").getAbsolutePath();
        }
        System.out.println("Using jlibtorrent 32 bits: " + libPath);
        return libPath;
    }

    private static String getLinux32JLibtorrentPath() {
        String jarPath = new File(FrostWireUtils.getFrostWireJarPath()).getAbsolutePath();
        boolean isRelease = !jarPath.contains("frostwire-desktop");
        String libPath = jarPath + File.separator + (isRelease ? "libjlibtorrentX86.so" : "lib/native/libjlibtorrentX86.so");
        if (!new File(libPath).exists()) {
            libPath = new File(jarPath + File.separator + "../../lib/native/libjlibtorrentx86.so").getAbsolutePath();
        }
        System.out.println("Using jlibtorrent 32 bits: " + libPath);
        return libPath;
    }
}

