/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.VPNBitTorrentDisabledWarningLabel;
import com.limegroup.gnutella.gui.VPNDropGuard;
import com.limegroup.gnutella.gui.VPNStatusRefresher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public final class VPNStatusButton
extends JPanel
implements VPNStatusRefresher.VPNStatusListener {
    private final IconButton iconButton = new IconButton("vpn_off");
    private final VPNBitTorrentDisabledWarningLabel vpnDropGuardLabel;
    private boolean lastVPNStatus;
    static final String VPN_URL = "http://www.frostwire.com/vpn";

    VPNStatusButton() {
        this.iconButton.setBorder(null);
        this.vpnDropGuardLabel = this.createVPNDisconnectLabel();
        this.initActionListener();
    }

    private void initActionListener() {
        this.iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIMediator.openURL(VPNStatusButton.VPN_URL);
            }
        });
    }

    private VPNBitTorrentDisabledWarningLabel createVPNDisconnectLabel() {
        VPNBitTorrentDisabledWarningLabel bitTorrentDisabledWarning = new VPNBitTorrentDisabledWarningLabel();
        bitTorrentDisabledWarning.setText("<html><b>" + I18n.tr("VPN Off: BitTorrent disabled") + "</b></html>");
        bitTorrentDisabledWarning.setToolTipText(I18n.tr("Due to current settings without VPN connection BitTorrent will not start. Click to see the settings screen"));
        bitTorrentDisabledWarning.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VPNStatusButton.this.onVPNBitTorrentDisabledWarningLabelClicked();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VPNStatusButton.this.onVPNBitTorrentDisabledWarningLabelClicked();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VPNStatusButton.this.onVPNBitTorrentDisabledWarningLabelClicked();
            }
        });
        return bitTorrentDisabledWarning;
    }

    private void onVPNBitTorrentDisabledWarningLabelClicked() {
        VPNDropGuard.canUseBitTorrent(true, new Runnable(){

            @Override
            public void run() {
                VPNStatusButton.this.updateVPNIcon(false);
                GUIMediator.instance().getStatusLine().refresh();
            }
        });
    }

    private void updateVPNIcon(boolean vpnIsOn) {
        this.lastVPNStatus = vpnIsOn;
        if (vpnIsOn) {
            this.iconButton.setIcon(GUIMediator.getThemeImage("vpn_on"));
            this.iconButton.setToolTipText("<html><p width=\"260\">" + I18n.tr("FrostWire has detected a VPN connection, your privacy is safe from prying eyes.") + "</p></html>");
        } else {
            this.iconButton.setIcon(GUIMediator.getThemeImage("vpn_off"));
            this.iconButton.setToolTipText("<html><p width=\"260\">" + I18n.tr("FrostWire can't detect an encrypted VPN connection, your privacy is at risk. Click icon to set up an encrypted VPN connection.") + "</p></html>");
        }
        this.removeAll();
        this.add(this.iconButton);
        if (!vpnIsOn && this.vpnDropGuardLabel.shouldBeShown()) {
            this.add(this.vpnDropGuardLabel);
        }
    }

    @Override
    public void onStatusUpdated(boolean vpnIsOn) {
        this.updateVPNIcon(vpnIsOn);
    }

    public boolean getLastVPNStatus() {
        return this.lastVPNStatus;
    }
}

