/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.bugs.LocalClientInfo;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class FatalBugManager {
    private static final Logger LOG = Logger.getLogger(FatalBugManager.class);

    private FatalBugManager() {
    }

    public static void handleFatalBug(Throwable bug) {
        if (bug instanceof ThreadDeath) {
            throw (ThreadDeath)bug;
        }
        bug.printStackTrace();
        LocalClientInfoFactory factoryToUse = LimeWireModule.instance().getLimeWireGUIModule().getLimeWireGUI().getLocalClientInfoFactory();
        final LocalClientInfo info = factoryToUse.createLocalClientInfo(bug, Thread.currentThread().getName(), null, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FatalBugManager.reviewBug(info);
            }
        });
    }

    private static String warning() {
        return "You are using FrostWire. www.frostwire.com";
    }

    public static void reviewBug(final LocalClientInfo info) {
        final JDialog DIALOG = new JDialog();
        DIALOG.setTitle("Fatal Error");
        Dimension DIALOG_DIMENSION = new Dimension(100, 300);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        MultiLineLabel label = new MultiLineLabel(FatalBugManager.warning() + "\n\nFrostWire has encountered a fatal internal error and will now exit. This is generally caused by a corrupted installation.  Please try downloading and installing FrostWire again.\n\nTo aid with debugging, please click 'Send' to notify FrostWire about the problem. If desired, you can click 'Review' to look at the information that will be sent. If the problem persists, please visit www.frostwire.com and click the 'Support' link.\n\nThank You.", 400);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(label);
        JPanel buttonPanel = new JPanel();
        JButton sendButton = new JButton("Send");
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FatalBugManager.sendToServlet(info);
                DIALOG.dispose();
                System.exit(1);
            }
        });
        JButton reviewButton = new JButton("Review");
        reviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextArea textArea = new JTextArea(info.toBugReport());
                textArea.setColumns(50);
                textArea.setEditable(false);
                textArea.selectAll();
                textArea.copy();
                textArea.setCaretPosition(0);
                JScrollPane scroller = new JScrollPane(textArea);
                scroller.setBorder(BorderFactory.createEtchedBorder());
                scroller.setPreferredSize(new Dimension(500, 200));
                FatalBugManager.showMessage(DIALOG, scroller);
            }
        });
        JButton discardButton = new JButton("Discard");
        discardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
                System.exit(1);
            }
        });
        buttonPanel.add(sendButton);
        buttonPanel.add(reviewButton);
        buttonPanel.add(discardButton);
        mainPanel.add(labelPanel);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = DIALOG.getSize();
        DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        DIALOG.setVisible(true);
        try {
            SplashWindow.instance().setVisible(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DIALOG.toFront();
    }

    private static void sendToServlet(LocalClientInfo info) {
        try {
            HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC).post(BugSettings.BUG_REPORT_SERVER.getValue(), 6000, "FrostWire-" + FrostWireUtils.getFrostWireVersion(), info.toBugReport(), "text/plain", false);
        }
        catch (Exception e) {
            LOG.error("Error sending bug report", e);
        }
    }

    private static void showMessage(Component parent, Component toDisplay) {
        JOptionPane.showMessageDialog(parent, toDisplay, "Fatal Error - Review", 1);
    }
}

