/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.FileTransfer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.limewire.util.OSUtils;

public class FileTransferable
implements Transferable {
    private final List<File> files;
    private final List<? extends FileTransfer> lazyFiles;
    static final DataFlavor URIFlavor = FileTransferable.createURIFlavor();
    static final DataFlavor URIFlavor16 = FileTransferable.createURIFlavor16();
    private static final List<? extends FileTransfer> EMPTY_FILE_TRANSFER_LiST = Collections.emptyList();

    private static DataFlavor createURIFlavor() {
        try {
            return new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private static DataFlavor createURIFlavor16() {
        try {
            return new DataFlavor("text/uri-list;representationclass=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public FileTransferable(List<File> files) {
        this(files, EMPTY_FILE_TRANSFER_LiST);
    }

    FileTransferable(List<File> realFiles, List<? extends FileTransfer> lazyFiles) {
        if (realFiles == null) {
            throw new NullPointerException("realFiles must not be null");
        }
        if (lazyFiles == null) {
            throw new NullPointerException("lazyFiles must not be empty");
        }
        this.files = new ArrayList<File>(realFiles);
        this.lazyFiles = new ArrayList<FileTransfer>(lazyFiles);
    }

    private List<File> getFiles() {
        if (!this.lazyFiles.isEmpty()) {
            for (FileTransfer fileTransfer : this.lazyFiles) {
                File f = fileTransfer.getFile();
                if (f == null) continue;
                this.files.add(f);
            }
            this.lazyFiles.clear();
        }
        return this.files;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.getFiles();
        }
        if (URIFlavor != null && URIFlavor.equals(flavor) || URIFlavor16 != null && URIFlavor16.equals(flavor)) {
            StringBuilder sb = new StringBuilder();
            String lineSep = System.getProperty("line.separator");
            for (File file : this.getFiles()) {
                URI uri = file.toURI();
                if (sb.length() > 0) {
                    sb.append(lineSep);
                }
                sb.append(uri.toString());
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (OSUtils.isWindows()) {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, URIFlavor, URIFlavor16};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.javaFileListFlavor) || flavor.equals(URIFlavor) || flavor.equals(URIFlavor16);
    }
}

