/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import javax.swing.JComponent;

public class TorrentURITransferHandler
extends LimeTransferHandler {
    private static final long serialVersionUID = 5212990516247901330L;

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return this.canImport(c, flavors);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return DNDUtils.contains(transferFlavors, FileTransferable.URIFlavor);
    }

    @Override
    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return this.importData(c, t);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            URI[] uris = DNDUtils.getURIs(t);
            if (this.areAllTorrentURLs(uris)) {
                if (uris.length == 1) {
                    GUIMediator.instance().openTorrentURI(uris[0].toString(), true);
                } else {
                    for (URI uri : uris) {
                        GUIMediator.instance().openTorrentURI(uri.toString(), false);
                    }
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    boolean areAllTorrentURLs(URI[] uris) {
        for (URI uri : uris) {
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                return false;
            }
            String path = uri.getPath();
            if (path != null && path.toLowerCase(Locale.US).endsWith(".torrent")) continue;
            return false;
        }
        return true;
    }
}

