/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.gui.bittorrent.TorrentSaveFolderComponent;
import com.frostwire.gui.bittorrent.TorrentSeedingSettingComponent;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.limewire.util.StringUtils;

class BitTorrentSettingsWindow
extends SetupWindow {
    private static final String LEARN_MORE_URL = "https://www.quora.com/What-is-seeding-on-FrostWire";
    private TorrentSaveFolderComponent _torrentSaveFolderComponent;
    private TorrentSeedingSettingComponent _torrentSeedingSettingComponent;

    BitTorrentSettingsWindow(SetupManager manager) {
        super(manager, I18n.tr("BitTorrent Sharing Settings"), BitTorrentSettingsWindow.describeText(), LEARN_MORE_URL);
    }

    private static String describeText() {
        return I18n.tr("Choose a folder where files downloaded from the BitTorrent network should be saved to.\nPlease select if you want to \"Seed\" or to not \"Seed\" finished downloads. The link below has more information about \"Seeding\".");
    }

    @Override
    protected void createWindow() {
        super.createWindow();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this._torrentSaveFolderComponent = new TorrentSaveFolderComponent(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        mainPanel.add((Component)this._torrentSaveFolderComponent, gbc);
        this._torrentSaveFolderComponent.putClientProperty("skin_property_dark_box_background", Boolean.TRUE);
        this._torrentSeedingSettingComponent = new TorrentSeedingSettingComponent(false, true);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        mainPanel.add((Component)this._torrentSeedingSettingComponent, gbc);
        this._torrentSeedingSettingComponent.putClientProperty("skin_property_dark_box_background", Boolean.TRUE);
        this._torrentSeedingSettingComponent.updateUI();
        this.setSetupComponent(mainPanel);
    }

    @Override
    public void applySettings(boolean loadCoreComponents) throws ApplySettingsException {
        ArrayList<String> errors = new ArrayList<String>(2);
        this.applyTorrentDataSaveFolderSettings(errors);
        this.applyTorrentSeedingSettings(errors);
        if (!errors.isEmpty()) {
            throw new ApplySettingsException(StringUtils.explode(errors, "\n\n"));
        }
    }

    private void applyTorrentSeedingSettings(List<String> errors) {
        if (!this._torrentSeedingSettingComponent.hasOneBeenSelected()) {
            errors.add("<html><p>" + I18n.tr("You forgot to select your finished downloads \"Seeding\" setting.") + "</p>\n<p></p><p align=\"right\"><a href=\"" + LEARN_MORE_URL + "\">" + I18n.tr("What is \"Seeding\"?") + "</a></p></html>");
            return;
        }
        SharingSettings.SEED_FINISHED_TORRENTS.setValue(this._torrentSeedingSettingComponent.wantsSeeding());
    }

    private void applyTorrentDataSaveFolderSettings(List<String> errors) {
        File folder = new File(this._torrentSaveFolderComponent.getTorrentSaveFolderPath());
        if (folder.exists() && folder.isDirectory() && folder.canWrite()) {
            SharingSettings.TORRENT_DATA_DIR_SETTING.setValue(folder);
        } else if (!folder.mkdirs()) {
            errors.add(I18n.tr("FrostWire could not create the Torrent Data Folder {0}", folder));
        } else {
            SharingSettings.TORRENT_DATA_DIR_SETTING.setValue(folder);
        }
        LibrarySettings.setupInitialLibraryFolders();
    }
}

