/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IntentPanel
extends JPanel {
    private final JRadioButton mightUseButton = new JRadioButton();
    private final JRadioButton willNotButton = new JRadioButton();

    public IntentPanel() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mightUseButton);
        bg.add(this.willNotButton);
        this.setBorder(BorderFactory.createLineBorder(ThemeMediator.LIGHT_BORDER_COLOR));
        this.setBackground(GUIUtils.hexToColor("F7F7F7"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        JLabel almostDone = new JLabel(I18n.tr("You're almost done!"));
        JLabel stateIntent = new JLabel(I18n.tr("State your intent below to start using FrostWire") + " " + FrostWireUtils.getFrostWireVersion());
        Line line = new Line();
        MultiLineLabel description = new MultiLineLabel(I18n.tr("FrostWire is a peer-to-peer program for sharing authorized files only.  Installing and using the program does not constitute a license for obtaining or distributing unauthorized content."), 500);
        URLLabel findMore = new URLLabel("http://www.frostwire.com/?id=terms", I18n.tr("Find out more..."));
        Ditherer ditherer = new Ditherer(GUIUtils.hexToColor("E2E2E2"), GUIUtils.hexToColor("ECECEC"), 1, new Ditherer.PolygonShader(2.0f));
        DitherPanel willNot = new DitherPanel(ditherer, null);
        willNot.setLayout(new GridBagLayout());
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.willNotButton.setText("<html><div display=\"block\" color=\"#515151\" size=\"13\">" + I18n.tr("I <b>will not</b> use FrostWire {0} for copyright infringement.", FrostWireUtils.getFrostWireVersion()) + "</div></html>");
        this.willNotButton.setOpaque(false);
        this.willNotButton.setIconTextGap(10);
        willNot.add((Component)this.willNotButton, gbc);
        willNot.setBorder(BorderFactory.createEtchedBorder(GUIUtils.hexToColor("C8C8C8"), GUIUtils.hexToColor("FBFBFB")));
        DitherPanel mightUse = new DitherPanel(ditherer, null);
        mightUse.setLayout(new GridBagLayout());
        this.mightUseButton.setText("<html><div display=\"block\" color=\"#515151\" size=\"13\">" + I18n.tr("I <b>might use</b> FrostWire {0} for copyright infringement.", FrostWireUtils.getFrostWireVersion()) + "</div></html>");
        this.mightUseButton.setOpaque(false);
        this.mightUseButton.setIconTextGap(10);
        mightUse.add((Component)this.mightUseButton, gbc);
        mightUse.setBorder(BorderFactory.createEtchedBorder(GUIUtils.hexToColor("C8C8C8"), GUIUtils.hexToColor("FBFBFB")));
        almostDone.setFont(almostDone.getFont().deriveFont(24.0f));
        almostDone.setForeground(GUIUtils.hexToColor("0086CA"));
        stateIntent.setFont(stateIntent.getFont().deriveFont(16.0f));
        stateIntent.setForeground(GUIUtils.hexToColor("333333"));
        description.setFont(description.getFont().deriveFont(14.0f));
        description.setForeground(GUIUtils.hexToColor("333333"));
        line.setColor(GUIUtils.hexToColor("C8C8C8"));
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 3;
        gbc.gridx = 1;
        this.add((Component)almostDone, gbc);
        this.add((Component)stateIntent, gbc);
        gbc.insets = new Insets(10, 0, 10, 0);
        this.add((Component)line, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)description, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)findMore, gbc);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        gbc.insets = new Insets(20, 70, 0, 0);
        this.add((Component)willNot, gbc);
        gbc.insets = new Insets(13, 70, 0, 0);
    }

    boolean hasSelection() {
        return this.willNotButton.isSelected() || this.mightUseButton.isSelected();
    }

    boolean isWillNot() {
        return this.willNotButton.isSelected();
    }

    void addButtonListener(ActionListener changeListener) {
        this.willNotButton.addActionListener(changeListener);
        this.mightUseButton.addActionListener(changeListener);
    }
}

