/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.options.OptionsTreeModel;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.OptionsTreeSelectionListener;
import com.limegroup.gnutella.gui.trees.FilteredTreeModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

final class OptionsTreeManager {
    private final JScrollPane SCROLL_PANE;
    private final JTree TREE;
    private final OptionsTreeModel TREE_MODEL = new OptionsTreeModel();
    private final FilteredTreeModel FILTERED_TREE_MODEL = new FilteredTreeModel(this.TREE_MODEL, true);

    OptionsTreeManager() {
        this.TREE = new JTree();
        this.TREE.setEditable(false);
        this.TREE.setShowsRootHandles(true);
        this.TREE.setRootVisible(false);
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.addTreeSelectionListener(new OptionsTreeSelectionListener(this.TREE));
        this.TREE.setModel(this.FILTERED_TREE_MODEL);
        this.SCROLL_PANE = new JScrollPane(this.TREE);
        this.SCROLL_PANE.setPreferredSize(new Dimension(150, 2000));
        this.SCROLL_PANE.setMinimumSize(new Dimension(150, 300));
    }

    final OptionsTreeNode addNode(String parentKey, String childKey, String displayName, String keywordText) {
        OptionsTreeNode node = this.TREE_MODEL.addNode(parentKey, childKey, displayName);
        assert (node != null);
        if (keywordText != null) {
            String[] keywords;
            for (String keyword : keywords = StringUtils.split(I18NConvert.instance().getNorm(keywordText), " \".,';:()[]")) {
                this.FILTERED_TREE_MODEL.addSearchKey(node, keyword);
            }
        }
        return node;
    }

    final Component getComponent() {
        return this.SCROLL_PANE;
    }

    void setSelection(String key) {
        if (key == null) {
            return;
        }
        OptionsTreeNode root = (OptionsTreeNode)this.TREE_MODEL.getRoot();
        OptionsTreeNode node = null;
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            node = (OptionsTreeNode)en.nextElement();
            if (!key.equals(node.getTitleKey())) continue;
            TreePath tp = new TreePath(node.getPath());
            this.TREE.expandPath(tp);
            this.TREE.scrollPathToVisible(tp);
            this.TREE.setSelectionPath(tp);
            return;
        }
    }

    void setDefaultSelection() {
        OptionsTreeNode root = (OptionsTreeNode)this.TREE_MODEL.getRoot();
        if (root == null) {
            return;
        }
        OptionsTreeNode node = null;
        Enumeration<TreeNode> en = root.children();
        if (!en.hasMoreElements()) {
            return;
        }
        node = (OptionsTreeNode)en.nextElement();
        if (node == null) {
            return;
        }
        TreePath tp = new TreePath(node.getPath());
        this.TREE.scrollPathToVisible(tp);
        this.TREE.setSelectionPath(tp);
        this.TREE.collapsePath(tp);
    }

    void setFilterText(String text) {
        TreePath path = this.TREE.getSelectionPath();
        boolean collapsed = this.TREE.isCollapsed(path);
        this.FILTERED_TREE_MODEL.filterByText(text);
        if (text.length() > 0) {
            this.expandAllNodes();
        } else {
            this.collapseAllNodes();
        }
        if (path != null) {
            this.TREE.setSelectionPath(path);
            if (text.length() == 0) {
                if (collapsed) {
                    this.TREE.collapsePath(path);
                } else {
                    this.TREE.expandPath(path);
                }
            }
            this.TREE.scrollPathToVisible(path);
        }
    }

    private void expandAllNodes() {
        for (int i = this.TREE_MODEL.getChildCount(this.TREE_MODEL.getRoot()) - 1; i >= 0; --i) {
            Object[] path = new Object[]{this.TREE_MODEL.getRoot(), this.TREE_MODEL.getChild(this.TREE_MODEL.getRoot(), i)};
            this.TREE.expandPath(new TreePath(path));
        }
    }

    private void collapseAllNodes() {
        for (int i = this.TREE_MODEL.getChildCount(this.TREE_MODEL.getRoot()) - 1; i >= 0; --i) {
            Object[] path = new Object[]{this.TREE_MODEL.getRoot(), this.TREE_MODEL.getChild(this.TREE_MODEL.getRoot(), i)};
            this.TREE.collapsePath(new TreePath(path));
        }
    }
}

