/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoreSaveTemplateProcessor {
    public static final String ARTIST_LABEL = "artist";
    public static final String ALBUM_LABEL = "album";
    public static final String HOME_LABEL = "home";
    static final String TEMPLATE_PROCESSOR_MISSING_DELIMETER = "STORE_TEMPLATE_PROCESSOR_MISSING_DELIMETER";
    static final String TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT = "STORE_TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT";
    static final String TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE = "STORE_TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE";
    private static final List<Character> END_DELIMS = new ArrayList<Character>();

    public boolean isValid(String template) throws IllegalTemplateException {
        HashMap<String, String> subs = new HashMap<String, String>();
        subs.put(ARTIST_LABEL, "");
        subs.put(ALBUM_LABEL, "");
        subs.put(HOME_LABEL, "");
        this.getOutputDirectory(template, subs, new File("."));
        return true;
    }

    public File getOutputDirectory(String template, Map<String, String> substitutions, File outDir) throws IllegalTemplateException {
        if (template == null) {
            return outDir;
        }
        if (template.equals("")) {
            return outDir;
        }
        if (template.equals(".")) {
            return outDir;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer var = new StringBuffer();
        int s = 0;
        block5: for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            switch (s) {
                case 0: {
                    if (c == '$') {
                        s = 1;
                        continue block5;
                    }
                    buf.append(c);
                    continue block5;
                }
                case 1: {
                    if (this.isDelim(c)) {
                        s = 2;
                        var = new StringBuffer();
                        continue block5;
                    }
                    if (Character.isWhitespace(c)) continue block5;
                    throw new IllegalTemplateException(i, TEMPLATE_PROCESSOR_MISSING_DELIMETER, template);
                }
                case 2: {
                    if (this.isDelim(c)) {
                        String variable = var.toString().replaceAll("\\s", "");
                        String replacement = substitutions.get(variable);
                        if (replacement == null) {
                            throw new IllegalTemplateException(i, TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT, template);
                        }
                        buf.append(replacement);
                        s = 0;
                        continue block5;
                    }
                    var.append(c);
                }
            }
        }
        if (s == 2) {
            throw new IllegalTemplateException(template.length(), TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE, template);
        }
        return new File(outDir, buf.toString());
    }

    private boolean isDelim(char c) {
        for (Character ch : END_DELIMS) {
            if (ch.charValue() != c) continue;
            return true;
        }
        return false;
    }

    static {
        END_DELIMS.add(Character.valueOf('{'));
        END_DELIMS.add(Character.valueOf('}'));
        END_DELIMS.add(Character.valueOf('('));
        END_DELIMS.add(Character.valueOf(')'));
        END_DELIMS.add(Character.valueOf('['));
        END_DELIMS.add(Character.valueOf(']'));
    }

    public static final class IllegalTemplateException
    extends ParseException {
        private static final long serialVersionUID = -3544104037008917572L;
        private final String template;

        public IllegalTemplateException(int pos, String msg, String template) {
            super(msg, pos);
            this.template = template;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            String s = null;
            try {
                s = I18n.tr(super.getMessage());
            }
            catch (Exception e) {
                s = e.getLocalizedMessage();
            }
            sb.append(s);
            sb.append(System.getProperty("line.separator"));
            sb.append(this.template);
            sb.append(System.getProperty("line.separator"));
            int N = this.getErrorOffset();
            for (int i = 0; i < N; ++i) {
                sb.append(' ');
            }
            sb.append('^');
            return sb.toString();
        }
    }

    private static interface States {
        public static final int LOOKING_FOR_DOLLAR = 0;
        public static final int HAVE_DOLLAR = 1;
        public static final int INSIDE_DELIMS = 2;
    }
}

