/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes.ipfilter;

import com.frostwire.util.Logger;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.IPFilterPaneItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;

public class IPFilterHttpListener
implements HttpClient.HttpClientListener {
    private static Logger LOG = Logger.getLogger(IPFilterHttpListener.class);
    private final IPFilterPaneItem ipFilterPaneItem;
    private int totalRead = 0;
    private long contentLength = -1L;
    private final File downloadedFile;
    private final FileOutputStream fos;
    private final String downloadingString = I18n.tr("Downloading");

    public IPFilterHttpListener(IPFilterPaneItem ipFilterPaneItem, File downloadedFile) throws FileNotFoundException {
        this.downloadedFile = downloadedFile;
        this.ipFilterPaneItem = ipFilterPaneItem;
        try {
            this.fos = new FileOutputStream(downloadedFile);
        }
        catch (FileNotFoundException e) {
            LOG.error("IPFilterHttpListener can't create output stream -> " + e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public void onError(HttpClient client, Throwable e) {
        LOG.info("onError(): " + e.getMessage());
        LOG.error(e.getMessage(), e);
        this.enableImportControls();
    }

    @Override
    public void onData(HttpClient client, byte[] buffer, int offset, int length) {
        this.totalRead += length;
        try {
            this.fos.write(buffer, offset, length);
        }
        catch (Throwable t) {
            this.onError(client, t);
            return;
        }
        if (this.contentLength != -1L) {
            this.updateProgressBar((int)((float)this.totalRead * 100.0f / (float)this.contentLength), this.downloadingString);
        }
    }

    @Override
    public void onComplete(HttpClient client) {
        LOG.info("onComplete()");
        try {
            this.fos.flush();
            this.fos.close();
        }
        catch (Throwable t) {
            LOG.error("onComplete(): " + t.getMessage(), t);
            this.onError(client, t);
            return;
        }
        this.updateProgressBar(100, "");
        this.enableImportControls();
        this.importFromIPBlockFileAsync(this.downloadedFile);
    }

    @Override
    public void onCancel(HttpClient client) {
        this.enableImportControls();
    }

    @Override
    public void onHeaders(HttpClient httpClient, Map<String, List<String>> headerFields) {
        List<String> contentLengthHeader;
        LOG.info("onHeaders()");
        if (headerFields != null && headerFields.containsKey("Content-Length") && (contentLengthHeader = headerFields.get("Content-Length")) != null && !contentLengthHeader.isEmpty()) {
            this.contentLength = Long.parseLong(contentLengthHeader.get(0));
        }
    }

    private void enableImportControls() {
        this.ipFilterPaneItem.enableImportControls(true);
    }

    private void updateProgressBar(int progress, String statusString) {
        this.ipFilterPaneItem.updateProgressBar(progress, statusString);
    }

    private void importFromIPBlockFileAsync(File downloadedFile) {
        this.ipFilterPaneItem.importFromIPBlockFileAsync(downloadedFile, true);
    }
}

