/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.RangeSlider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class LabeledRangeSlider
extends JPanel {
    private final RangeSlider slider = new RangeSlider();
    private final JLabel titleLabel;
    private final JLabel minLabel;
    private final JLabel maxLabel;

    public LabeledRangeSlider(String title, String defaultMaxText, int minValue, int maxValue) {
        this.slider.setValue(minValue);
        this.slider.setUpperValue(maxValue);
        this.titleLabel = new JLabel(I18n.tr(title));
        this.minLabel = new JLabel(String.valueOf(minValue));
        this.maxLabel = defaultMaxText == null ? new JLabel(I18n.tr("Max")) : new JLabel(I18n.tr(defaultMaxText));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridwidth = 0;
        this.add((Component)this.titleLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.slider, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 21;
        this.add((Component)this.minLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.add(Box.createGlue(), c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.anchor = 21;
        this.add((Component)this.maxLabel, c);
    }

    public void addChangeListener(ChangeListener listener) {
        this.slider.addChangeListener(listener);
    }

    public void setLowerValue(int value) {
        this.slider.setLowerValue(value);
    }

    public int getLowerValue() {
        return this.slider.getLowerValue();
    }

    public int getUpperValue() {
        return this.slider.getUpperValue();
    }

    public void setUpperValue(int value) {
        this.slider.setUpperValue(value);
    }

    public void setMinimum(int min) {
        this.slider.setMinimum(min);
    }

    public void setMaximum(int max) {
        this.slider.setMaximum(max);
    }

    public JLabel getMinimumValueLabel() {
        return this.minLabel;
    }

    public JLabel getMaximumValueLabel() {
        return this.maxLabel;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slider.setEnabled(enabled);
    }
}

