/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.filters.SearchFilter;
import com.frostwire.gui.filters.SearchFilterFactory;
import com.frostwire.gui.filters.SearchFilterFactoryImpl;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.search.CrawlPagedWebSearchPerformer;
import com.frostwire.search.CrawledSearchResult;
import com.frostwire.search.DatabaseCrawlCache;
import com.frostwire.search.FileSearchResult;
import com.frostwire.search.LibTorrentMagnetDownloader;
import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchManager;
import com.frostwire.search.SearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.archiveorg.ArchiveorgCrawledSearchResult;
import com.frostwire.search.pixabay.PixabayItemSearchResult;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.search.torrent.TorrentSearchResult;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.ApplicationHeader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.AbstractUISearchResult;
import com.limegroup.gnutella.gui.search.ArchiveorgUISearchResult;
import com.limegroup.gnutella.gui.search.PixabayUISearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SoundcloudUISearchResult;
import com.limegroup.gnutella.gui.search.TorrentUISearchResult;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.settings.SearchSettings;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

public final class SearchMediator {
    public static final Logger LOG = Logger.getLogger(SearchMediator.class);
    private final long MAX_CRAWLCACHE_SIZE = 256000000L;
    public static final int QUERY_VALID = 0;
    public static final int QUERY_EMPTY = 1;
    private static final int QUERY_TOO_SHORT = 2;
    private static final int QUERY_TOO_LONG = 3;
    public static final int QUERY_XML_TOO_LONG = 4;
    static final String DOWNLOAD_STRING = I18n.tr("Download");
    static final String REPEAT_SEARCH_STRING = I18n.tr("Repeat Search");
    static final String SEARCH_FOR_KEYWORDS = I18n.tr("Search for Keywords: {0}");
    static final String DOWNLOAD_PARTIAL_FILES_STRING = I18n.tr("Download Partial Files");
    static final String TORRENT_DETAILS_STRING = I18n.tr("Torrent Details");
    static final String SOUNDCLOUD_DETAILS_STRING = I18n.tr("View in Soundcloud");
    static final String ARCHIVEORG_DETAILS_STRING = I18n.tr("View in Archive.org");
    static final String PIXABAY_DETAILS_STRING = I18n.tr("View in Pixabay");
    static final String CLOSE_TAB_STRING = I18n.tr("Close Tab");
    static final String CLOSE_ALL_TABS = I18n.tr("Close All Tabs");
    static final String CLOSE_OTHER_TABS_STRING = I18n.tr("Close Other Tabs");
    static final String CLOSE_TABS_TO_THE_RIGHT = I18n.tr("Close Tabs to the Right");
    private final SearchManager manager;
    private static SearchResultDisplayer RESULT_DISPLAYER;
    private static SearchFilterFactory SEARCH_FILTER_FACTORY;
    private static final SearchMediator instance;

    public static SearchMediator instance() {
        return instance;
    }

    private SearchMediator() {
        String splashScreenString = I18n.tr("Loading Search Window...");
        GUIMediator.setSplashScreenString(splashScreenString);
        GUIMediator.addRefreshListener(SearchMediator.getSearchResultDisplayer());
        SearchMediator.getSearchResultDisplayer().setSearchListener(e -> {
            SearchResultMediator resultPanel = SearchMediator.getSearchResultDisplayer().getSelectedResultPanel();
            if (resultPanel != null) {
                resultPanel.updateFiltersPanel();
            }
        });
        new Thread(() -> {
            try {
                DatabaseCrawlCache databaseCrawlCache = new DatabaseCrawlCache();
                if (databaseCrawlCache.sizeInBytes() > 256000000L) {
                    LOG.info("SearchMediator() - reseting crawl cache, too big");
                    databaseCrawlCache.clear();
                    databaseCrawlCache = new DatabaseCrawlCache();
                    LOG.info("SearchMediator() - crawl cache reset successful");
                }
                CrawlPagedWebSearchPerformer.setCache(databaseCrawlCache);
            }
            catch (Throwable t) {
                LOG.error("could not set database crawl cache", t);
            }
        }, "CrawlPagedWebSearchPerformer-initializer").start();
        CrawlPagedWebSearchPerformer.setMagnetDownloader(new LibTorrentMagnetDownloader());
        this.manager = SearchManager.getInstance();
        this.manager.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                SearchMediator.this.onResults(token, results);
            }

            @Override
            public void onError(long token, SearchError error) {
            }

            @Override
            public void onStopped(long token) {
                SearchMediator.this.onFinished(token);
            }
        });
    }

    public static void requestSearchFocus() {
        GUIMediator.instance().getMainFrame().getApplicationHeader().requestSearchFocus();
    }

    void repeatSearch(SearchResultMediator rp, SearchInformation info) {
        if (!SearchMediator.validate(info)) {
            return;
        }
        this.stopSearch(rp.getToken());
        long token = this.newSearchToken();
        rp.setToken(token);
        SearchMediator.updateSearchIcon(token, true);
        rp.resetFiltersPanel();
        this.performSearch(token, info.getQuery());
    }

    public long triggerSearch(SearchInformation info) {
        if (!SearchMediator.validate(info)) {
            return 0L;
        }
        long token = this.newSearchToken();
        SearchResultMediator resultTab = SearchMediator.addResultTab(token, info);
        this.performSearch(token, info.getQuery());
        return token;
    }

    private long newSearchToken() {
        return Math.abs(System.nanoTime());
    }

    private static boolean validate(SearchInformation info) {
        switch (SearchMediator.validateInfo(info)) {
            case 1: {
                return false;
            }
            case 2: {
                GUIMediator.showMessage(I18n.tr("Your search must be at least three characters to avoid congesting the network."));
                return false;
            }
            case 3: {
                GUIMediator.showMessage(I18n.tr("Your search is too long. Please make your search smaller and try again."));
                return false;
            }
            case 0: {
                return true;
            }
        }
        return true;
    }

    public static int validateInfo(SearchInformation info) {
        String query = I18NConvert.instance().getNorm(info.getQuery());
        if (query.length() == 0) {
            return 1;
        }
        if (query.length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            return 3;
        }
        return 0;
    }

    private void performSearch(long token, String query) {
        if (StringUtils.isNullOrEmpty(query, true)) {
            return;
        }
        this.manager.stop(token);
        for (SearchEngine se : SearchEngine.getEngines()) {
            if (!se.isEnabled()) continue;
            SearchPerformer p = se.getPerformer(token, query);
            this.manager.perform(p);
        }
    }

    private List<SearchResult> filter(List<SearchResult> results, List<String> searchTokens) {
        List<SearchResult> list = searchTokens == null || searchTokens.isEmpty() ? Collections.emptyList() : this.filter2(results, searchTokens);
        return list;
    }

    private List<SearchResult> filter2(List<? extends SearchResult> results, List<String> searchTokens) {
        LinkedList<SearchResult> list = new LinkedList<SearchResult>();
        try {
            for (SearchResult searchResult : results) {
                if (searchResult instanceof CrawledSearchResult) {
                    if (!this.filter(new LinkedList<String>(searchTokens), searchResult)) continue;
                    list.add(searchResult);
                    continue;
                }
                list.add(searchResult);
            }
        }
        catch (Throwable e) {
            list.clear();
        }
        return list;
    }

    private boolean filter(List<String> tokens, SearchResult sr) {
        StringBuilder sb = new StringBuilder();
        sb.append(sr.getDisplayName());
        if (sr instanceof CrawledSearchResult) {
            sb.append(((CrawledSearchResult)sr).getParent().getDisplayName());
        }
        if (sr instanceof FileSearchResult) {
            sb.append(((FileSearchResult)sr).getFilename());
        }
        String str = this.sanitize(sb.toString());
        str = this.normalize(str);
        Iterator<String> it = tokens.iterator();
        while (it.hasNext()) {
            String token = it.next();
            if (!str.contains(token)) continue;
            it.remove();
        }
        return tokens.isEmpty();
    }

    private static String stripHtml(String str) {
        str = str.replaceAll("\\<.*?>", "");
        str = str.replaceAll("\\&.*?\\;", "");
        return str;
    }

    private String sanitize(String str) {
        str = SearchMediator.stripHtml(str);
        str = str.replaceAll("\\.torrent|www\\.|\\.com|\\.net|[\\\\\\/%_;\\-\\.\\(\\)\\[\\]\\n\\r\u00c3\u0090&~{}\\*@\\^'=!,\u00c2\u00a1|#\u00c3\u0080\u00c3\u0081]", " ");
        str = StringUtils.removeDoubleSpaces(str);
        return str.trim();
    }

    private List<String> tokenize(String keywords) {
        keywords = this.sanitize(keywords);
        HashSet<String> tokens = new HashSet<String>(Arrays.asList(keywords.toLowerCase(Locale.US).split(" ")));
        return new ArrayList<String>(this.normalizeTokens(tokens));
    }

    private Set<String> normalizeTokens(Set<String> tokens) {
        HashSet<String> normalizedTokens = new HashSet<String>();
        for (String token : tokens) {
            String norm = this.normalize(token);
            normalizedTokens.add(norm);
        }
        return normalizedTokens;
    }

    private String normalize(String token) {
        String norm = Normalizer.normalize(token, Normalizer.Form.NFKD);
        norm = norm.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        norm = norm.toLowerCase(Locale.US);
        return norm;
    }

    private static void updateSearchIcon(long token, boolean active) {
        GUIMediator.safeInvokeAndWait(() -> {
            SearchResultMediator trp = SearchMediator.getResultPanelForGUID(token);
            if (trp != null) {
                trp.updateSearchIcon(active);
            }
        });
    }

    private static List<UISearchResult> convertResults(List<? extends SearchResult> results, SearchEngine engine, String query) {
        ArrayList<UISearchResult> result = new ArrayList<UISearchResult>();
        for (SearchResult searchResult : results) {
            AbstractUISearchResult ui = null;
            if (searchResult instanceof SoundcloudSearchResult) {
                ui = new SoundcloudUISearchResult((SoundcloudSearchResult)searchResult, engine, query);
            } else if (searchResult instanceof TorrentSearchResult) {
                ui = new TorrentUISearchResult((TorrentSearchResult)searchResult, engine, query);
            } else if (searchResult instanceof ArchiveorgCrawledSearchResult) {
                ui = new ArchiveorgUISearchResult((ArchiveorgCrawledSearchResult)searchResult, engine, query);
            } else if (searchResult instanceof PixabayItemSearchResult) {
                ui = new PixabayUISearchResult((PixabayItemSearchResult)searchResult, engine, query);
            }
            if (ui == null) continue;
            result.add(ui);
        }
        return result;
    }

    private static SearchResultMediator addResultTab(long token, SearchInformation info) {
        List<String> searchTokens = SearchMediator.instance().tokenize(info.getQuery());
        return SearchMediator.getSearchResultDisplayer().addResultTab(token, searchTokens, info);
    }

    public static void downloadFromPanel(SearchResultMediator rp, SearchResultDataLine[] lines) {
        SearchMediator.downloadAll(lines);
        rp.refresh();
    }

    static void doDownload(SearchResultMediator rp) {
        SearchResultDataLine[] lines = rp.getAllSelectedLines();
        SwingUtilities.invokeLater(() -> {
            SearchMediator.downloadAll(lines);
            rp.refresh();
        });
    }

    private static void downloadAll(SearchResultDataLine[] lines) {
        if (lines == null || lines.length == 0) {
            return;
        }
        GUIMediator.instance().showTransfers(TransfersTab.FilterMode.DOWNLOADING);
        for (SearchResultDataLine line : lines) {
            if (line == null) continue;
            SearchMediator.downloadLine(line);
        }
        if (lines.length == 1) {
            SearchResultDataLine srdl = lines[0];
            String hash = srdl.getHash();
            BTDownloadMediator btDownloadMediator = GUIMediator.instance().getBTDownloadMediator();
            List<BTDownload> downloads = btDownloadMediator.getDownloads();
            for (BTDownload d : downloads) {
                if (d.getHash() == null || !d.getHash().equals(hash)) continue;
                btDownloadMediator.selectBTDownload(d);
                btDownloadMediator.ensureDownloadVisible(d);
                return;
            }
        }
    }

    private static void downloadLine(SearchResultDataLine line) {
        if (line == null) {
            throw new NullPointerException("Tried to download null line");
        }
        line.getSearchResult().download(false);
    }

    static void setTabDisplayCount(SearchResultMediator rp) {
        SearchMediator.getSearchResultDisplayer().setTabDisplayCount(rp);
    }

    static void searchKilled(SearchResultMediator panel) {
        SearchMediator.instance().stopSearch(panel.getToken());
        panel.cleanup();
        ApplicationHeader header = GUIMediator.instance().getMainFrame().getApplicationHeader();
        header.requestSearchFocus();
    }

    void stopSearch(long token) {
        this.manager.stop(token);
    }

    public void shutdown() {
        this.manager.stop();
    }

    private static SearchResultMediator getResultPanelForGUID(long token) {
        return SearchMediator.getSearchResultDisplayer().getResultPanelForGUID(token);
    }

    public static JComponent getResultComponent() {
        return SearchMediator.getSearchResultDisplayer().getComponent();
    }

    public static SearchResultDisplayer getSearchResultDisplayer() {
        if (RESULT_DISPLAYER == null) {
            RESULT_DISPLAYER = new SearchResultDisplayer();
        }
        return RESULT_DISPLAYER;
    }

    private static SearchFilterFactory getSearchFilterFactory() {
        if (SEARCH_FILTER_FACTORY == null) {
            SEARCH_FILTER_FACTORY = new SearchFilterFactoryImpl();
        }
        return SEARCH_FILTER_FACTORY;
    }

    private void onResults(long token, List<? extends SearchResult> results) {
        List<SearchResult> filtered;
        SearchResultMediator rp = SearchMediator.getResultPanelForGUID(token);
        if (rp != null && !rp.isStopped() && (filtered = this.filter(results, rp.getSearchTokens())) != null && !filtered.isEmpty()) {
            SearchEngine se = SearchEngine.getSearchEngineByName(filtered.get(0).getSource());
            if (se == null) {
                return;
            }
            List<UISearchResult> uiResults = SearchMediator.convertResults(filtered, se, rp.getQuery());
            GUIMediator.safeInvokeAndWait(() -> {
                try {
                    SearchFilter filter = SearchMediator.getSearchFilterFactory().createFilter();
                    for (UISearchResult sr : uiResults) {
                        if (!filter.allow(sr)) continue;
                        SearchMediator.getSearchResultDisplayer().addQueryResult(token, sr, rp);
                    }
                }
                catch (Exception e) {
                    LOG.error("Error adding search result to UI", e);
                }
            });
        }
    }

    private void onFinished(long token) {
        SearchResultMediator rp = SearchMediator.getResultPanelForGUID(token);
        if (rp != null) {
            SearchMediator.updateSearchIcon(token, false);
            rp.setToken(0L);
        }
    }

    public void clearCache() {
        try {
            CrawlPagedWebSearchPerformer.clearCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getTotalTorrents() {
        long r = 0L;
        try {
            r = CrawlPagedWebSearchPerformer.getCacheNumEntries();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return r;
    }

    static {
        instance = new SearchMediator();
    }
}

