/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.DataLine;
import java.util.HashMap;

public class HashBasedDataLineModel<T extends DataLine<E>, E>
extends BasicDataLineModel<T, E> {
    private static final long serialVersionUID = -4697217283217173076L;
    protected HashMap<E, Integer> _indexes = new HashMap();

    public HashBasedDataLineModel(Class<? extends T> dataLineClass) {
        super(dataLineClass);
    }

    protected int forceAdd(T dl, int row) {
        this._indexes.put(dl.getInitializeObject(), new Integer(row));
        int addedAt = super.add(dl, row);
        this.remapIndexes(addedAt + 1);
        return addedAt;
    }

    @Override
    public int add(T dl, int row) {
        Object init = dl.getInitializeObject();
        if (this._indexes.containsKey(init)) {
            return -1;
        }
        this._indexes.put(init, new Integer(row));
        int addedAt = super.add(dl, row);
        this.remapIndexes(addedAt + 1);
        return addedAt;
    }

    @Override
    public void remove(int row) {
        Object init = this.get(row).getInitializeObject();
        this._indexes.remove(init);
        super.remove(row);
        this.remapIndexes(row);
    }

    @Override
    public int getRow(E o) {
        Integer idx = this._indexes.get(o);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    @Override
    public void doResort() {
        super.doResort();
        this._indexes.clear();
        this.remapIndexes(0);
    }

    @Override
    public boolean contains(Object o) {
        return this._indexes.containsKey(o);
    }

    @Override
    public void clear() {
        this._indexes.clear();
        super.clear();
    }

    public void remapIndexes(int start) {
        int end = this.getRowCount();
        for (int i = start; i < end; ++i) {
            this._indexes.put(this.get(i).getInitializeObject(), new Integer(i));
        }
    }

    public void initializeObjectChanged(E old, E now) {
        Integer val = this._indexes.remove(old);
        this._indexes.put(now, val);
    }
}

