/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class SortArrowIcon
implements Icon {
    public static final int NONE = 0;
    public static final int DESCENDING = 1;
    public static final int ASCENDING = 2;
    protected int direction;
    protected int width = 8;
    protected int height = 8;
    private static final Icon DESCENDING_ICON = new SortArrowIcon(1);
    private static final Icon ASCENDING_ICON = new SortArrowIcon(2);
    private static final Icon NONE_ICON = new SortArrowIcon(0);

    public static Icon getAscendingIcon() {
        return ASCENDING_ICON;
    }

    public static Icon getDescendingIcon() {
        return DESCENDING_ICON;
    }

    public static Icon getNoneIcon() {
        return NONE_ICON;
    }

    public SortArrowIcon(int direction) {
        this.direction = direction;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.direction == 0) {
            return;
        }
        Color bg = c.getBackground();
        Color light = null;
        Color shade = null;
        if (bg.getRed() >= 252 && bg.getGreen() >= 252 && bg.getBlue() >= 252) {
            light = bg.darker();
            shade = light.darker();
        } else if (bg.getRed() <= 3 && bg.getGreen() <= 3 && bg.getBlue() <= 3) {
            shade = bg.brighter();
            light = shade.brighter();
        } else {
            light = bg.brighter();
            shade = bg.darker();
        }
        int w = this.width;
        int h = this.height;
        int m = w / 2;
        switch (this.direction) {
            case 1: {
                g.setColor(shade);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x + m, y + h);
                g.setColor(light);
                g.drawLine(x + w, y, x + m, y + h);
                break;
            }
            case 2: {
                g.setColor(shade);
                g.drawLine(x + m, y, x, y + h);
                g.setColor(light);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + m, y, x + w, y + h);
            }
        }
    }
}

