/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.limewire.setting.SettingsFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public final class FrostWireUtils {
    private static final String FROSTWIRE_VERSION = "6.7.9";
    private static final int BUILD_NUMBER = 277;
    private static final boolean IS_RUNNING_FROM_SOURCE = new File("README.md").exists();

    private FrostWireUtils() {
    }

    public static String getFrostWireVersion() {
        return FROSTWIRE_VERSION;
    }

    public static int getBuildNumber() {
        return 277;
    }

    public static boolean isIsRunningFromSource() {
        return IS_RUNNING_FROM_SOURCE;
    }

    public static boolean hasSettingsLoadSaveFailures() {
        return SettingsFactory.hasLoadSaveFailure();
    }

    public static void resetSettingsLoadSaveFailures() {
        SettingsFactory.resetLoadSaveFailure();
    }

    public static String getFrostWireJarPath() {
        return new File(FrostWireUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
    }

    public static File getFrostWireRootFolder() {
        String root = null;
        if (OSUtils.isWindowsVista() || OSUtils.isWindows7()) {
            root = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOWNLOADS);
        } else if (OSUtils.isWindows()) {
            root = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOCUMENTS);
        }
        if (root == null || "".equals(root)) {
            root = CommonUtils.getUserHomeDir().getPath();
        }
        return new File(root, "FrostWire");
    }

    public static Set<File> getFrostWire4SaveDirectories() {
        HashSet<File> result = new HashSet<File>();
        try {
            String[] types;
            File settingFile = new File(CommonUtils.getFrostWire4UserSettingsDir(), "frostwire.props");
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(settingFile);
            props.load(fis);
            IOUtils.closeQuietly(fis);
            if (props.containsKey("DIRECTORY_FOR_SAVING_FILES")) {
                result.add(new File(props.getProperty("DIRECTORY_FOR_SAVING_FILES")));
            }
            for (String type : types = new String[]{"document", "application", "audio", "video", "image"}) {
                String key = "DIRECTORY_FOR_SAVING_" + type + "_FILES";
                if (!props.containsKey(key)) continue;
                result.add(new File(props.getProperty(key)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static File getUserMusicFolder() {
        File musicFile = OSUtils.isMacOSX() ? new File(CommonUtils.getUserHomeDir(), "Music") : (OSUtils.isWindowsXP() ? new File(CommonUtils.getUserHomeDir(), "My Documents" + File.separator + "My Music") : (OSUtils.isWindowsVista() || OSUtils.isWindows7() ? new File(CommonUtils.getUserHomeDir(), "Music") : (OSUtils.isUbuntu() ? new File(CommonUtils.getUserHomeDir(), "Music") : new File(CommonUtils.getUserHomeDir(), "Music"))));
        return musicFile;
    }

    public static File getUserVideoFolder() {
        File videoFile = OSUtils.isMacOSX() ? new File(CommonUtils.getUserHomeDir(), "Movies") : (OSUtils.isWindowsXP() ? new File(CommonUtils.getUserHomeDir(), "My Documents" + File.separator + "My Videos") : (OSUtils.isWindowsVista() || OSUtils.isWindows7() ? new File(CommonUtils.getUserHomeDir(), "Videos") : (OSUtils.isUbuntu() ? new File(CommonUtils.getUserHomeDir(), "Videos") : new File(CommonUtils.getUserHomeDir(), "Videos"))));
        return videoFile;
    }

    public static void getFrostWireVersionBuild(int[] result) {
        String[] vStrArray = FrostWireUtils.getFrostWireVersion().split("\\.");
        result[0] = Integer.valueOf(vStrArray[0]);
        result[1] = Integer.valueOf(vStrArray[1]);
        result[2] = Integer.valueOf(vStrArray[2]);
        result[3] = FrostWireUtils.getBuildNumber();
    }
}

