/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class SystemTime {
    public static final long TIME_GRANULARITY_MILLIS = 25L;
    private static final int STEPS_PER_SECOND = 40;
    private static SystemTimeProvider instance;
    private static final boolean SOD_IT_LETS_USE_HPC = false;
    private static volatile List<TickConsumer> systemTimeConsumers;
    private static volatile List<TickConsumer> monotoneTimeConsumers;
    private static volatile List<ChangeListener> clock_change_list;

    public static void useRawProvider() {
        if (!(instance instanceof RawProvider)) {
            Debug.out("Whoa, someone already created a non-raw provider!");
            instance = new RawProvider();
        }
    }

    public static long getCurrentTime() {
        return instance.getTime();
    }

    public static long getMonotonousTime() {
        return instance.getMonoTime();
    }

    public static long getSteppedMonotonousTime() {
        return instance.getSteppedMonoTime();
    }

    public static long getOffsetTime(long offsetMS) {
        return instance.getTime() + offsetMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> new_list = new ArrayList<TickConsumer>(systemTimeConsumers);
            new_list.add(c);
            systemTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> new_list = new ArrayList<TickConsumer>(systemTimeConsumers);
            new_list.remove(c);
            systemTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMonotonousConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> new_list = new ArrayList<TickConsumer>(monotoneTimeConsumers);
            new_list.add(c);
            monotoneTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterMonotonousConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> new_list = new ArrayList<TickConsumer>(monotoneTimeConsumers);
            new_list.remove(c);
            monotoneTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClockChangeListener(ChangeListener c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<ChangeListener> new_list = new ArrayList<ChangeListener>(clock_change_list);
            new_list.add(c);
            clock_change_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClockChangeListener(ChangeListener c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<ChangeListener> new_list = new ArrayList<ChangeListener>(clock_change_list);
            new_list.remove(c);
            clock_change_list = new_list;
        }
    }

    public static long getHighPrecisionCounter() {
        return System.nanoTime();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1; ++i) {
            new Thread(){

                @Override
                public void run() {
                    long cstart = SystemTime.getCurrentTime();
                    long mstart = SystemTime.getMonotonousTime();
                    System.out.println("alter system clock to see differences between monotonous and current time");
                    long cLastRound = cstart;
                    long mLastRound = mstart;
                    while (true) {
                        long mnow = SystemTime.getMonotonousTime();
                        long cnow = SystemTime.getCurrentTime();
                        System.out.println("current: " + (cnow - cstart) + " monotonous:" + (mnow - mstart) + " delta current:" + (cnow - cLastRound) + " delta monotonous:" + (mnow - mLastRound));
                        cLastRound = cnow;
                        mLastRound = mnow;
                        try {
                            Thread.sleep(15L);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }.start();
        }
    }

    static {
        systemTimeConsumers = new ArrayList<TickConsumer>();
        monotoneTimeConsumers = new ArrayList<TickConsumer>();
        clock_change_list = new ArrayList<ChangeListener>();
        try {
            if (System.getProperty("azureus.time.use.raw.provider", "0").equals("1")) {
                System.out.println("Warning: Using Raw Provider");
                instance = new RawProvider();
            } else {
                instance = new SteppedProvider();
            }
        }
        catch (Throwable e) {
            instance = new SteppedProvider();
        }
    }

    public static interface ChangeListener {
        public void clockChangeDetected(long var1, long var3);

        public void clockChangeCompleted(long var1, long var3);
    }

    public static interface TickConsumer {
        public void consume(long var1);
    }

    private static class RawProvider
    implements SystemTimeProvider {
        private final Thread updater;

        private RawProvider() {
            System.out.println("SystemTime: using raw time provider");
            this.updater = new Thread("SystemTime"){
                long last_time;

                @Override
                public void run() {
                    while (true) {
                        long change;
                        long current_time = this.getTime();
                        if (this.last_time != 0L) {
                            long offset = current_time - this.last_time;
                            if (offset < 0L || offset > 5000L) {
                                change = offset;
                                Iterator it = clock_change_list.iterator();
                                while (it.hasNext()) {
                                    try {
                                        ((ChangeListener)it.next()).clockChangeDetected(current_time, change);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            } else {
                                change = 0L;
                            }
                        } else {
                            change = 0L;
                        }
                        this.last_time = current_time;
                        if (change != 0L) {
                            Iterator it = clock_change_list.iterator();
                            while (it.hasNext()) {
                                try {
                                    ((ChangeListener)it.next()).clockChangeCompleted(current_time, change);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        List consumer_list_ref = systemTimeConsumers;
                        for (int i = 0; i < consumer_list_ref.size(); ++i) {
                            TickConsumer cons = (TickConsumer)consumer_list_ref.get(i);
                            try {
                                cons.consume(current_time);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        consumer_list_ref = monotoneTimeConsumers;
                        long mono_time = this.getMonoTime();
                        for (int i = 0; i < consumer_list_ref.size(); ++i) {
                            TickConsumer cons = (TickConsumer)consumer_list_ref.get(i);
                            try {
                                cons.consume(mono_time);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        @Override
        public long getTime() {
            return System.currentTimeMillis();
        }

        @Override
        public long getMonoTime() {
            return SystemTime.getHighPrecisionCounter() / 1000000L;
        }

        @Override
        public long getSteppedMonoTime() {
            return this.getMonoTime();
        }
    }

    private static class SteppedProvider
    implements SystemTimeProvider {
        private static final long HPC_START = SystemTime.getHighPrecisionCounter() / 1000000L;
        private final Thread updater;
        private volatile long stepped_time = 0L;
        private volatile long currentTimeOffset = System.currentTimeMillis();
        private AtomicLong last_approximate_time = new AtomicLong();
        private volatile int access_count;
        private volatile int slice_access_count;
        private volatile int access_average_per_slice;
        private volatile int drift_adjusted_granularity;
        private volatile long stepped_mono_time;

        private SteppedProvider() {
            this.updater = new Thread("SystemTime"){

                @Override
                public void run() {
                    long adjustedTimeOffset = currentTimeOffset;
                    Average access_average = Average.getInstance(1000, 10);
                    Average drift_average = Average.getInstance(1000, 10);
                    long lastOffset = adjustedTimeOffset;
                    long lastSecond = -1000L;
                    int tick_count = 0;
                    while (true) {
                        TickConsumer cons;
                        int i;
                        long change;
                        long rawTime;
                        long newMonotoneTime;
                        long delta;
                        if ((delta = (newMonotoneTime = (rawTime = System.currentTimeMillis()) - adjustedTimeOffset) - stepped_time) < 0L || delta > 1000L) {
                            stepped_time += 25L;
                            adjustedTimeOffset = rawTime - stepped_time;
                        } else {
                            stepped_time = newMonotoneTime;
                        }
                        if (++tick_count == 40) {
                            change = adjustedTimeOffset - lastOffset;
                            if (change != 0L) {
                                Iterator it = clock_change_list.iterator();
                                while (it.hasNext()) {
                                    try {
                                        ((ChangeListener)it.next()).clockChangeDetected(rawTime, change);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                                lastOffset = adjustedTimeOffset;
                                currentTimeOffset = adjustedTimeOffset;
                            }
                            long drift = stepped_time - lastSecond - 1000L;
                            lastSecond = stepped_time;
                            drift_average.addValue(drift);
                            drift_adjusted_granularity = (int)(25L + drift_average.getAverage() / 40L);
                            access_average.addValue(access_count);
                            access_average_per_slice = (int)(access_average.getAverage() / 40L);
                            access_count = 0;
                            tick_count = 0;
                        } else {
                            change = 0L;
                        }
                        slice_access_count = 0;
                        stepped_mono_time = stepped_time;
                        long adjustedTime = stepped_time + currentTimeOffset;
                        if (change != 0L) {
                            Iterator it = clock_change_list.iterator();
                            while (it.hasNext()) {
                                try {
                                    ((ChangeListener)it.next()).clockChangeCompleted(adjustedTime, change);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        List consumersRef = monotoneTimeConsumers;
                        for (i = 0; i < consumersRef.size(); ++i) {
                            cons = (TickConsumer)consumersRef.get(i);
                            try {
                                cons.consume(stepped_time);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        consumersRef = systemTimeConsumers;
                        for (i = 0; i < consumersRef.size(); ++i) {
                            cons = (TickConsumer)consumersRef.get(i);
                            try {
                                cons.consume(adjustedTime);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        @Override
        public long getTime() {
            return this.getMonoTime() + this.currentTimeOffset;
        }

        @Override
        public long getMonoTime() {
            long adjusted_time;
            long averageSliceStep = this.access_average_per_slice;
            if (averageSliceStep > 0L) {
                long sliceStep = (long)(this.drift_adjusted_granularity * this.slice_access_count) / averageSliceStep;
                if (sliceStep >= (long)this.drift_adjusted_granularity) {
                    sliceStep = this.drift_adjusted_granularity - 1;
                }
                adjusted_time = sliceStep + this.stepped_time;
            } else {
                adjusted_time = this.stepped_time;
            }
            ++this.access_count;
            ++this.slice_access_count;
            long approxBuffered = this.last_approximate_time.get();
            if (adjusted_time < approxBuffered) {
                adjusted_time = approxBuffered;
            } else {
                this.last_approximate_time.compareAndSet(approxBuffered, adjusted_time);
            }
            return adjusted_time;
        }

        @Override
        public long getSteppedMonoTime() {
            return this.stepped_mono_time;
        }
    }

    protected static interface SystemTimeProvider {
        public long getTime();

        public long getMonoTime();

        public long getSteppedMonoTime();
    }
}

